package ch.docuteam.packer.gui.launcher.actions;

import static ch.docuteam.packer.gui.PackerConstants.HOME_PNG;

import java.awt.Desktop;
import java.awt.event.ActionEvent;

import javax.swing.Action;
import javax.swing.ImageIcon;

import ch.docuteam.packer.gui.launcher.LauncherView;
import ch.docuteam.tools.translations.I18N;

public class OpenDocuteamHomepageAction extends AbstractDocuAction {

	public OpenDocuteamHomepageAction(LauncherView owner) {
		super(I18N.translate("ActionOpenDocuteamHomepage"), new ImageIcon(HOME_PNG), owner);
		putValue(Action.SHORT_DESCRIPTION, I18N.translate("ToolTipOpenDocuteamHomepage"));
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		openDocuteamHomepage();

	}
	
	//TODO this method here is used by the logo and this is probably not a good design
	public void openDocuteamHomepage() {
		if (!java.awt.Desktop.isDesktopSupported()) {
			System.err.println("Desktop is not supported");
			return;
		}

		Desktop desktop = Desktop.getDesktop();

		if (!desktop.isSupported(Desktop.Action.BROWSE)) {
			System.err.println("Desktop doesn't support the browse action");
			return;
		}

		try {
			desktop.browse(new java.net.URI("http://www.docuteam.ch"));
		} catch (java.lang.Exception ex) {
			ex.printStackTrace();
		}
	}

}
