package ch.docuteam.packer.gui.launcher.actions;

import static ch.docuteam.packer.gui.PackerConstants.EXCEPTION_PNG;

import java.awt.event.ActionEvent;

import javax.swing.Action;
import javax.swing.ImageIcon;

import ch.docuteam.packer.gui.launcher.LauncherView;
import ch.docuteam.tools.gui.SystemOutView;
import ch.docuteam.tools.translations.I18N;

public class OpenExceptionWindowAction extends AbstractDocuAction {
	
	
	public OpenExceptionWindowAction(LauncherView owner) {
		super(I18N.translate("ActionOpenExceptionWindow"),
				new ImageIcon(EXCEPTION_PNG), owner);
		putValue(Action.SHORT_DESCRIPTION, I18N.translate("ToolTipOpenExceptionWindow"));
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		SystemOutView.open();
	}

}
