package ch.docuteam.packer.gui.sipView.actions;

import java.awt.Cursor;
import java.awt.FileDialog;
import java.io.File;

import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

import ch.docuteam.darc.exceptions.FileOrFolderIsInUseException;
import ch.docuteam.darc.exceptions.OriginalSIPIsMissingException;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.gui.SmallPeskyMessageWindow;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.translations.I18N;

public class SaveUtility {
	
	private Document document;
	private SIPView sipView;
	
	public SaveUtility() {
		super();
		// TODO Auto-generated constructor stub
	}

	/**
	 * The [Save as...] button was clicked:
	 */
	protected void saveAsButtonClicked()
	{
		FileDialog fileDialog = new FileDialog(sipView, I18N.translate("TitleSaveSIPAs"), FileDialog.SAVE);
		fileDialog.setDirectory(new File(sipView.getLauncherView().getLastUsedOpenOrSaveDirectory()).getAbsolutePath());
		fileDialog.setFile(document.getSIPName());
		fileDialog.setLocationRelativeTo(sipView);

		fileDialog.setVisible(true);
		if (fileDialog.getFile() == null) {
			return;
		}

		saveCopyAs(fileDialog.getDirectory() + fileDialog.getFile());
	}
	protected void saveCopyAs(String filePath) {
		saveCopyAs(filePath, false);
	}
	
	protected void saveCopyAs(final String filePath, final boolean doUnlockAndCleanupAfterwards)
	{
		if (document == null) {
			return;
		}

		new SwingWorker<Integer, Object>()
		{
			@Override
			public Integer doInBackground() {
				SmallPeskyMessageWindow waitWindow = SmallPeskyMessageWindow.openBlocking(sipView,
						I18N.translate("MessageTempSavingSIP"));
				try {
					sipView.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

					// This prevents the LauncherView to open this document
					// while being saved:
					sipView.getLauncherView().savingDocumentInProgress(sipView);

					if (filePath == null || filePath.isEmpty()) {
						// This is the regular save:

						if (!document.canWrite()) {
							JOptionPane.showMessageDialog(sipView, I18N.translate("MessageIsReadOnlyCantSave"),
									I18N.translate("TitleCantSaveSIP"), JOptionPane.ERROR_MESSAGE);
							return 0;
						}

						Logger.getLogger().debug("Saving document");

						// Save the SIP:
						if (SIPView.saveWithBackups) {
							document.saveWithBackup();
						} else {
							document.saveWithoutBackup();
						}
					} else {
						// This is save-as:

						Logger.getLogger().debug("Saving document as: " + filePath);

						// Save SIP or ZIP to a different location:
						document.saveTo(filePath);

					}

					// I have to reread the SIPTable in the launcher view
					// because I might have locked or unlocked a SIP in
					// the workspace when saving the SIP to a different place,
					// or I might have added a new SIP:
					// TODO This here doesn't make sense to me and i find it
					// should't be like that, but without it now there are
					// errors
					sipView.getLauncherView().getSipTable().rereadSIPTable();

					// Unlock and cleanup document in necessary:
					if (doUnlockAndCleanupAfterwards) {
						try {
							document.unlockIfNecessary();
							document.cleanupWorkingCopy();
						} catch (Exception e) {
							e.printStackTrace();
							JOptionPane.showMessageDialog(sipView, e.toString(),
									"Unable to cleanup working folder due to errors", JOptionPane.ERROR_MESSAGE);
						}
					}

					sipView.setFooterText(I18N.translate("MessageFooterSaved") + document.getFilePath());
					// Put the ORIGINAL metsFileName into the title, NOT the
					// working copy fileName!
					sipView.setTitle(document.getOriginalSIPFolder());
				} catch (FileOrFolderIsInUseException e) {
					waitWindow.close();
					JOptionPane.showMessageDialog(sipView,
							I18N.translate("MessageFileOrFolderIsInUseException", e.getOriginalSIPName(),
									e.getSecurityCopySIPName(), FileUtil.asFileName(e.getOriginalSIPName()),
									FileUtil.asFileName(e.getSecurityCopySIPName())),
							I18N.translate("TitleCantSaveSIP"), JOptionPane.ERROR_MESSAGE);
				} catch (OriginalSIPIsMissingException e) {
					waitWindow.close();
					JOptionPane.showMessageDialog(sipView,
							I18N.translate("MessageOriginalSIPIsMissingException", e.getOriginalSIPFolderPath()),
							I18N.translate("TitleCantCopySIP"), JOptionPane.WARNING_MESSAGE);
				} catch (Exception e) {
					e.printStackTrace();

					waitWindow.close();
					JOptionPane.showMessageDialog(sipView, e.toString(), I18N.translate("TitleCantSaveSIP"),
							JOptionPane.ERROR_MESSAGE);
					sipView.setFooterText(I18N.translate("MessageFooterCantSave") + document.getFilePath());
				} finally {
					sipView.getLauncherView().savingDocumentFinished(sipView);

					waitWindow.close();
					sipView.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));

					sipView.enableOrDisableActions();

					sipView.toFront();
					sipView.requestFocus();
				}

				return 0;
			}
		}.execute();
//		getTreeTableModel().refreshTreeStructure(getTreeTable().getPathForRow(selectedRow));
//		populateView(getDocument());
//		getTreeTableModel().refreshNodeaa(sipView.getTreeTable().getPathForRow(selectedRow), selectedRow, null);
	}
}
