package ch.docuteam.packer.gui.sipView.cellRenderer;

import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableCellRenderer;

import ch.docuteam.darc.mets.structmap.NodeAbstract.SubmitStatus;
import ch.docuteam.tools.translations.I18N;

public class SubmitStatusTableCellRenderer extends DefaultTableCellRenderer {
	@Override
	public void setValue(Object object) {
		if (object == null)
			return;

		SubmitStatus submitStatus = (SubmitStatus) object;
		switch (submitStatus) {
		case SubmitUndefined:
			setIcon(null);
			break;
		case SubmitRequested:
			setIcon(new ImageIcon("./resources/images/SubmitRequestedFlag.png"));
			break;
		case SubmitRequestPending:
			setIcon(new ImageIcon("./resources/images/SubmitRequestPendingFlag.png"));
			break;
		case SubmitFailed:
			setIcon(new ImageIcon("./resources/images/SubmitFailedFlag.png"));
			break;
		case Submitted:
			setIcon(new ImageIcon("./resources/images/SubmittedFlag.png"));
			break;
		default:
			setIcon(null);
			break;
		}

		setToolTipText(I18N.translate("HeaderPropertiesSubmitStatus") + " " + I18N.translate(submitStatus.toString()));
	}
}
