package ch.docuteam.packer.gui.launcher;

import ch.docuteam.packer.gui.FileProperty;
import ch.docuteam.tools.translations.I18N;

public enum Column {

	SIP, LOCKED_BY, SIZE, LAST_CHANGE_DATE, IS_READ_ONLY;

	public String getName() {
		switch (this) {
		case SIP:
			return I18N.translate("HeaderLauncherSIP");
		case LOCKED_BY:
			return I18N.translate("HeaderLauncherLockedBy");
		case SIZE:
			return I18N.translate("HeaderLauncherSize");
		case LAST_CHANGE_DATE:
			return I18N.translate("HeaderLauncherLastChangeDate");
		case IS_READ_ONLY:
			return I18N.translate("HeaderLauncherIsReadOnly");
		default:
			return "";
		}
	}

	public Class<?> getColumnClass() {
		switch (this) {
		case SIZE:
			return Long.class;
		case LAST_CHANGE_DATE:
			return Long.class;
		case IS_READ_ONLY:
			return Boolean.class;
		default:
			return Object.class;
		}
	}

	public Object getValue(FileProperty fileProperty) {
		switch (this) {
		case SIP:
			return fileProperty.getName();
		case LOCKED_BY:
			return fileProperty.getLockedBy();
		case SIZE:
			return fileProperty.getSize();
		case LAST_CHANGE_DATE:
			return fileProperty.getLastModified();
		case IS_READ_ONLY:
			return fileProperty.isLocked();
		default:
			return null;
		}
	}

}
