package ch.docuteam.packer.gui.launcher.actions;

import static ch.docuteam.packer.gui.PackerConstants.HELP_PNG;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.ImageIcon;

import ch.docuteam.packer.gui.launcher.LauncherView;
import ch.docuteam.tools.translations.I18N;

public class HelpAction extends AbstractDocuAction {

	public HelpAction(LauncherView owner) {
		super(I18N.translate("ActionHelp"), new ImageIcon(HELP_PNG), owner);
		putValue(Action.SHORT_DESCRIPTION, I18N.translate("ToolTipHelp"));
		putValue(Action.ACCELERATOR_KEY, owner.getKeyStroke(KeyEvent.VK_H,
				Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), KeyEvent.VK_F1, 0));
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		if (!java.awt.Desktop.isDesktopSupported()) {
			System.err.println("Desktop is not supported");
			return;
		}

		java.awt.Desktop desktop = java.awt.Desktop.getDesktop();

		if (!desktop.isSupported(java.awt.Desktop.Action.BROWSE)) {
			System.err.println("Desktop doesn't support the browse action");
			return;
		}

		try {
			desktop.browse(new java.net.URI(I18N.translate("HelpPageURL")));
		} catch (java.lang.Exception ex) {
			ex.printStackTrace();
		}

	}

}
