package ch.docuteam.packer.gui.sipView.cellRenderer;

import static ch.docuteam.packer.gui.PackerConstants.EDITABLE_COLUMN_INDEX;
import static ch.docuteam.packer.gui.PackerConstants.URL_PATTERN;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class UnfocusableCellRenderer extends DefaultTableCellRenderer {

	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus,
			int row, int column) {
		Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);

		// Display URLs in blue
		if (column == EDITABLE_COLUMN_INDEX && value != null
				&& value.toString().matches(URL_PATTERN)) {
			comp.setForeground(Color.blue);
		} else {
			comp.setForeground((Color) UIManager.get("Table.foreground"));
		}

		if (hasFocus) {
			table.changeSelection(row, 2, false, false);
		}
		return comp;
	}
}