package ch.docuteam.packer.gui.sipView.tableModel;

import javax.swing.table.AbstractTableModel;

import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.tools.translations.I18N;

public class FileDataViewTableModel extends AbstractTableModel {

	private NodeAbstract fileStructureNode;

	public void setFileStructureNode(NodeAbstract fileStructureNode) {
		this.fileStructureNode = fileStructureNode;
		fireTableDataChanged();
	}

	@Override
	public int getRowCount() {
		return 12;
	}

	@Override
	public int getColumnCount() {
		return 2;
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		if (columnIndex == 0) {
			switch (rowIndex) {
			case 0:
				return I18N.translate("HeaderName");
			case 1:
				return I18N.translate("HeaderPropertiesPath");
			case 2:
				return I18N.translate("HeaderType");
			case 3:
				return I18N.translate("HeaderPropertiesMIMEType");
			case 4:
				return I18N.translate("HeaderPropertiesFormat");
			case 5:
				return I18N.translate("HeaderPropertiesFormatKey");
			case 6:
				return I18N.translate("HeaderPropertiesSizeKB");
			case 7:
				return I18N.translate("HeaderPropertiesSize%");
			case 8:
				return I18N.translate("HeaderPropertiesChildren");
			case 9:
				return I18N.translate("HeaderPropertiesDescendants");
			case 10:
				return I18N.translate("HeaderPropertiesEvents");
			case 11:
				return I18N.translate("HeaderPropertiesSubmitStatus");
			}
		} else if (columnIndex == 1) {
			if (fileStructureNode == null)
				return null;

			switch (rowIndex) {
			case 0:
				return fileStructureNode.getLabel();
			case 1:
				return fileStructureNode.getPathString();
			case 2:
				return fileStructureNode.getType();
			case 3:
				return fileStructureNode.getMimeType();
			case 4:
				return fileStructureNode.getFormatName();
			case 5:
				return fileStructureNode.getFormatKey();
			case 6:
				return ((Long) (fileStructureNode.getSize() / 1024)).toString();
			case 7:
				return fileStructureNode.getRelativeSize().toString();
			case 8:
				return fileStructureNode.isFile() ? "-" : fileStructureNode.getChildCount();
			case 9:
				return fileStructureNode.isFile() ? "-" : fileStructureNode.getDescendantCount();
			case 10:
				return ((Integer) fileStructureNode.getMyEvents().size()).toString();
			case 11:
				return I18N.translate(fileStructureNode.getSubmitStatus().toString());
			}
		}

		return null;
	}

}
