/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterCriterion;
import uk.gov.nationalarchives.droid.core.interfaces.filter.RestrictionFactory;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Criterion;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Junction;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Restrictions;
import uk.gov.nationalarchives.droid.profile.AbstractProfileResource;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.report.dao.ReportLineItem;
import uk.gov.nationalarchives.droid.report.interfaces.ProfileReportData;

public final class ReportUtils {
    private static final String ROOT_FOLDER = "/";
    private static final Map<String, List<String>> REPORT_DEFS;

    private ReportUtils() {
    }

    static List<String> toResourcePaths(List<AbstractProfileResource> resources) {
        ArrayList<String> profileResourcePaths = new ArrayList<String>();
        for (AbstractProfileResource resource : resources) {
            profileResourcePaths.add(new File(resource.getUri()).getPath());
        }
        return profileResourcePaths;
    }

    static ProfileReportData buildProfileReportData(ProfileInstance profile, ReportLineItem reportLineItem) {
        ProfileReportData data = new ProfileReportData();
        data.setProfileName(profile.getName());
        data.setProfileId(profile.getUuid());
        data.setCount(reportLineItem.getCount());
        data.setSum(reportLineItem.getSum());
        data.setAverage(reportLineItem.getAverage());
        data.setMin(reportLineItem.getMinimum());
        data.setMax(reportLineItem.getMaximum());
        return data;
    }

    static Criterion buildFilter(Filter f1, Filter f2) {
        Junction outerConjunction = Restrictions.conjunction();
        if (f1 != null && f1.isEnabled()) {
            Junction profileCriteria = f1.isNarrowed() ? Restrictions.conjunction() : Restrictions.disjunction();
            for (FilterCriterion profileCriterion : f1.getCriteria()) {
                profileCriteria.add(RestrictionFactory.forFilterCriterion((FilterCriterion)profileCriterion));
            }
            outerConjunction.add((Criterion)profileCriteria);
        }
        if (f2 != null) {
            Junction reportItemCriteria = f2.isNarrowed() ? Restrictions.conjunction() : Restrictions.disjunction();
            for (FilterCriterion profileCriterion : f2.getCriteria()) {
                reportItemCriteria.add(RestrictionFactory.forFilterCriterion((FilterCriterion)profileCriterion));
            }
            outerConjunction.add((Criterion)reportItemCriteria);
        }
        return outerConjunction;
    }

    static void populateReportDefinitionsDirectory(File destinationDir, ClassLoader classLoader) throws IOException {
        for (String reportDefFilename : REPORT_DEFS.keySet()) {
            List<String> transformList = REPORT_DEFS.get(reportDefFilename);
            if (ROOT_FOLDER.equals(reportDefFilename)) {
                ReportUtils.copyTransforms(destinationDir, transformList, classLoader);
                continue;
            }
            String reportDirName = FilenameUtils.getBaseName((String)reportDefFilename);
            File reportDir = new File(destinationDir, reportDirName);
            reportDir.mkdir();
            ReportUtils.copyResourceToFile(reportDefFilename, reportDir, classLoader);
            ReportUtils.copyTransforms(reportDir, transformList, classLoader);
        }
    }

    private static void copyTransforms(File destinationDir, List<String> transformNames, ClassLoader classLoader) throws IOException {
        for (String transformName : transformNames) {
            ReportUtils.copyResourceToFile(transformName, destinationDir, classLoader);
        }
    }

    private static void copyResourceToFile(String resourceName, File destinationDir, ClassLoader classLoader) throws IOException {
        File reportDefFile = new File(destinationDir, resourceName);
        if (!reportDefFile.exists()) {
            reportDefFile.createNewFile();
            FileOutputStream out = new FileOutputStream(reportDefFile);
            InputStream in = classLoader.getResourceAsStream(resourceName);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            if (in != null) {
                in.close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    static {
        ArrayList noTransforms = new ArrayList();
        ArrayList<String> generalFiles = new ArrayList<String>();
        ArrayList<String> planetTransforms = new ArrayList<String>();
        generalFiles.add("Web page.html.xsl");
        generalFiles.add("Text.txt.xsl");
        planetTransforms.add("Planets XML.xml.xsl");
        REPORT_DEFS = new HashMap<String, List<String>>();
        REPORT_DEFS.put(ROOT_FOLDER, generalFiles);
        REPORT_DEFS.put("Total count of files and folders.xml", noTransforms);
        REPORT_DEFS.put("Total unreadable files.xml", noTransforms);
        REPORT_DEFS.put("Total unreadable folders.xml", noTransforms);
        REPORT_DEFS.put("File count and sizes.xml", noTransforms);
        REPORT_DEFS.put("File count and sizes by file extension.xml", noTransforms);
        REPORT_DEFS.put("File count and sizes by file format PUID.xml", noTransforms);
        REPORT_DEFS.put("File count and sizes by mime type.xml", noTransforms);
        REPORT_DEFS.put("File count and sizes by year last modified.xml", noTransforms);
        REPORT_DEFS.put("File count and sizes by month last modified.xml", noTransforms);
        REPORT_DEFS.put("File count and sizes by year and month last modified.xml", noTransforms);
        REPORT_DEFS.put("Comprehensive breakdown.xml", planetTransforms);
    }
}

