/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.export;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.export.ExportTask;
import uk.gov.nationalarchives.droid.export.interfaces.ExportManager;
import uk.gov.nationalarchives.droid.export.interfaces.ExportOptions;
import uk.gov.nationalarchives.droid.export.interfaces.ItemWriter;
import uk.gov.nationalarchives.droid.profile.ProfileContextLocator;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;

public class ExportManagerImpl
implements ExportManager {
    private ProfileContextLocator profileContextLocator;
    private ItemWriter<ProfileResourceNode> itemWriter;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public Future<?> exportProfiles(List<String> profileIds, String destination, Filter filter, ExportOptions options, String outputEncoding) {
        final ExportTask exportTask = new ExportTask(destination, profileIds, filter, options, outputEncoding, this.itemWriter, this.profileContextLocator);
        FutureTask<Object> task = new FutureTask<Object>((Runnable)exportTask, null){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (mayInterruptIfRunning) {
                    exportTask.cancel();
                }
                return super.cancel(false);
            }
        };
        this.executor.execute(task);
        return task;
    }

    public void setProfileContextLocator(ProfileContextLocator profileContextLocator) {
        this.profileContextLocator = profileContextLocator;
    }

    public void setItemWriter(ItemWriter<ProfileResourceNode> itemWriter) {
        this.itemWriter = itemWriter;
    }

    public void destroy() {
        this.executor.shutdownNow();
    }
}

