/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.expression.compiler.sequence;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.domesdaybook.expression.compiler.AstCompiler;
import net.domesdaybook.expression.parser.ParseException;
import net.domesdaybook.expression.parser.ParseUtils;
import net.domesdaybook.matcher.sequence.ByteSequenceMatcher;
import net.domesdaybook.matcher.sequence.CaseInsensitiveStringMatcher;
import net.domesdaybook.matcher.sequence.CaseSensitiveStringMatcher;
import net.domesdaybook.matcher.sequence.CombinedSequenceMatcher;
import net.domesdaybook.matcher.sequence.SequenceMatcher;
import net.domesdaybook.matcher.sequence.SingleByteSequenceMatcher;
import net.domesdaybook.matcher.singlebyte.AllBitMaskMatcher;
import net.domesdaybook.matcher.singlebyte.AnyBitMaskMatcher;
import net.domesdaybook.matcher.singlebyte.AnyByteMatcher;
import net.domesdaybook.matcher.singlebyte.ByteMatcher;
import net.domesdaybook.matcher.singlebyte.ByteSetMatcher;
import net.domesdaybook.matcher.singlebyte.SingleByteMatcher;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

public class SequenceMatcherCompiler
extends AstCompiler<SequenceMatcher> {
    @Override
    public final SequenceMatcher compile(CommonTree ast) throws ParseException {
        if (ast == null) {
            throw new ParseException("Null abstract syntax tree passed in to SequenceMatcherCompiler.");
        }
        try {
            return this.buildSequence(ast);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e);
        }
    }

    private SequenceMatcher buildSequence(CommonTree ast) throws ParseException {
        SequenceMatcher matcher = null;
        switch (ast.getToken().getType()) {
            case 4: {
                ArrayList<Byte> byteValuesToJoin = new ArrayList<Byte>();
                ArrayList<SingleByteMatcher> singleByteSequence = new ArrayList<SingleByteMatcher>();
                ArrayList<SequenceMatcher> sequences = new ArrayList<SequenceMatcher>();
                int stop = ast.getChildCount();
                block21: for (int childIndex = 0; childIndex < stop; ++childIndex) {
                    CommonTree child = (CommonTree)ast.getChild(childIndex);
                    switch (child.getToken().getType()) {
                        case 14: {
                            this.addCollectedSingleByteMatchers(singleByteSequence, sequences);
                            byteValuesToJoin.add(ParseUtils.getHexByteValue((Tree)child));
                            continue block21;
                        }
                        case 20: {
                            this.addCollectedSingleByteMatchers(singleByteSequence, sequences);
                            String str = ParseUtils.trimString(child.getText());
                            int end = str.length();
                            for (int charIndex = 0; charIndex < end; ++charIndex) {
                                byte byteValue = (byte)str.charAt(charIndex);
                                byteValuesToJoin.add(byteValue);
                            }
                            continue block21;
                        }
                        case 10: {
                            this.addCollectedByteValues(byteValuesToJoin, sequences);
                            singleByteSequence.add(this.getAllBitmaskMatcher(child));
                            continue block21;
                        }
                        case 11: {
                            this.addCollectedByteValues(byteValuesToJoin, sequences);
                            singleByteSequence.add(this.getAnyBitmaskMatcher(child));
                            continue block21;
                        }
                        case 7: {
                            SingleByteMatcher bytematch = this.getSetMatcher(child, false);
                            if (bytematch instanceof ByteMatcher) {
                                this.addCollectedSingleByteMatchers(singleByteSequence, sequences);
                                byteValuesToJoin.add(bytematch.getMatchingBytes()[0]);
                                continue block21;
                            }
                            this.addCollectedByteValues(byteValuesToJoin, sequences);
                            singleByteSequence.add(bytematch);
                            continue block21;
                        }
                        case 8: {
                            this.addCollectedByteValues(byteValuesToJoin, sequences);
                            singleByteSequence.add(this.getSetMatcher(child, true));
                            continue block21;
                        }
                        case 12: {
                            this.addCollectedByteValues(byteValuesToJoin, sequences);
                            singleByteSequence.add(this.getAnyByteMatcher(child));
                            continue block21;
                        }
                        case 53: {
                            this.addCollectedByteValues(byteValuesToJoin, sequences);
                            this.addCollectedSingleByteMatchers(singleByteSequence, sequences);
                            sequences.add(this.getCaseInsensitiveStringMatcher(child));
                            continue block21;
                        }
                        default: {
                            throw new ParseException(ParseUtils.getTypeErrorMessage(ast));
                        }
                    }
                }
                this.addCollectedByteValues(byteValuesToJoin, sequences);
                this.addCollectedSingleByteMatchers(singleByteSequence, sequences);
                matcher = sequences.size() == 1 ? (SequenceMatcher)sequences.get(0) : new CombinedSequenceMatcher(sequences);
                break;
            }
            case 14: {
                matcher = new ByteSequenceMatcher(ParseUtils.getHexByteValue((Tree)ast));
                break;
            }
            case 10: {
                matcher = new SingleByteSequenceMatcher(this.getAllBitmaskMatcher(ast));
                break;
            }
            case 11: {
                matcher = new SingleByteSequenceMatcher(this.getAnyBitmaskMatcher(ast));
                break;
            }
            case 7: {
                matcher = new SingleByteSequenceMatcher(this.getSetMatcher(ast, false));
                break;
            }
            case 8: {
                matcher = new SingleByteSequenceMatcher(this.getSetMatcher(ast, true));
                break;
            }
            case 12: {
                matcher = new SingleByteSequenceMatcher(this.getAnyByteMatcher(ast));
                break;
            }
            case 20: {
                String str = ParseUtils.trimString(ast.getText());
                matcher = new CaseSensitiveStringMatcher(str);
                break;
            }
            case 53: {
                matcher = this.getCaseInsensitiveStringMatcher(ast);
                break;
            }
            default: {
                throw new ParseException(ParseUtils.getTypeErrorMessage(ast));
            }
        }
        return matcher;
    }

    private void addCollectedByteValues(List<Byte> byteValuesToJoin, List<SequenceMatcher> sequences) {
        if (byteValuesToJoin.size() > 0) {
            ByteSequenceMatcher byteMatcher = new ByteSequenceMatcher(byteValuesToJoin);
            sequences.add(byteMatcher);
            byteValuesToJoin.clear();
        }
    }

    private void addCollectedSingleByteMatchers(List<SingleByteMatcher> matchers, List<SequenceMatcher> sequences) {
        if (matchers.size() > 0) {
            SingleByteSequenceMatcher matcher = new SingleByteSequenceMatcher(matchers);
            sequences.add(matcher);
            matchers.clear();
        }
    }

    private SequenceMatcher getCaseInsensitiveStringMatcher(CommonTree ast) {
        String str = ParseUtils.trimString(ast.getText());
        return new CaseInsensitiveStringMatcher(str);
    }

    private SingleByteMatcher getAllBitmaskMatcher(CommonTree ast) {
        byte bitmask = ParseUtils.getBitMaskValue((Tree)ast);
        return new AllBitMaskMatcher(bitmask);
    }

    private SingleByteMatcher getAnyBitmaskMatcher(CommonTree ast) {
        byte bitmask = ParseUtils.getBitMaskValue((Tree)ast);
        return new AnyBitMaskMatcher(bitmask);
    }

    private SingleByteMatcher getSetMatcher(CommonTree ast, boolean negated) throws ParseException {
        Set<Byte> byteSet = ParseUtils.calculateSetValue(ast);
        return ByteSetMatcher.buildOptimalMatcher(byteSet, negated);
    }

    private SingleByteMatcher getAnyByteMatcher(CommonTree ast) {
        return new AnyByteMatcher();
    }
}

