/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.expression.parser;

import java.util.HashSet;
import java.util.Set;
import net.domesdaybook.expression.parser.ParseException;
import net.domesdaybook.expression.parser.regularExpressionParser;
import net.domesdaybook.matcher.singlebyte.ByteUtilities;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

public class ParseUtils {
    public static final String TYPE_ERROR = "Type [%s] not supported by the compiler.";
    public static final String QUOTE = "'";

    private ParseUtils() {
    }

    public static byte parseHexByte(String hexByte) {
        return (byte)Integer.parseInt(hexByte, 16);
    }

    public static byte getHexByteValue(Tree treeNode) {
        return ParseUtils.parseHexByte(treeNode.getText());
    }

    public static byte getBitMaskValue(Tree treeNode) {
        Tree childNode = treeNode.getChild(0);
        return ParseUtils.parseHexByte(childNode.getText());
    }

    public static int getChildIntValue(Tree treeNode, int childIndex) {
        Tree childNode = treeNode.getChild(childIndex);
        return Integer.parseInt(childNode.getText(), 10);
    }

    public static String getChildStringValue(Tree treeNode, int childIndex) {
        return treeNode.getChild(childIndex).getText();
    }

    public static Set<Byte> calculateSetValue(CommonTree node) throws ParseException {
        HashSet<Byte> setValues = new HashSet<Byte>();
        int stop = node.getChildCount();
        block10: for (int childIndex = 0; childIndex < stop; ++childIndex) {
            CommonTree childNode = (CommonTree)node.getChild(childIndex);
            switch (childNode.getType()) {
                case 7: {
                    Set<Byte> nestedSetValues = ParseUtils.calculateSetValue(childNode);
                    setValues.addAll(nestedSetValues);
                    continue block10;
                }
                case 8: {
                    Set<Byte> nestedSetValues = ParseUtils.calculateSetValue(childNode);
                    setValues.addAll(ParseUtils.inverseOf(nestedSetValues));
                    continue block10;
                }
                case 14: {
                    setValues.add(ParseUtils.getHexByteValue((Tree)childNode));
                    continue block10;
                }
                case 10: {
                    byte allBitMask = ParseUtils.getBitMaskValue((Tree)childNode);
                    setValues.addAll(ByteUtilities.getBytesMatchingAllBitMask(allBitMask));
                    continue block10;
                }
                case 11: {
                    byte allBitMask = ParseUtils.getBitMaskValue((Tree)childNode);
                    setValues.addAll(ByteUtilities.getBytesMatchingAnyBitMask(allBitMask));
                    continue block10;
                }
                case 9: {
                    String minRange = ParseUtils.getChildStringValue((Tree)childNode, 0);
                    String maxRange = ParseUtils.getChildStringValue((Tree)childNode, 1);
                    int minRangeValue = minRange.startsWith(QUOTE) ? minRange.charAt(1) : Integer.parseInt(minRange, 16);
                    int maxRangeValue = maxRange.startsWith(QUOTE) ? maxRange.charAt(1) : Integer.parseInt(maxRange, 16);
                    if (minRangeValue > maxRangeValue) {
                        int swapTemp = minRangeValue;
                        minRangeValue = maxRangeValue;
                        maxRangeValue = swapTemp;
                    }
                    for (int rangeValue = minRangeValue; rangeValue <= maxRangeValue; ++rangeValue) {
                        setValues.add((byte)rangeValue);
                    }
                    continue block10;
                }
                case 20: {
                    int charIndex;
                    String stringValue = ParseUtils.trimString(childNode.getText());
                    for (charIndex = 0; charIndex < stringValue.length(); ++charIndex) {
                        char charAt = stringValue.charAt(charIndex);
                        setValues.add((byte)charAt);
                    }
                    continue block10;
                }
                case 53: {
                    int charIndex;
                    String stringValue = ParseUtils.trimString(childNode.getText());
                    for (charIndex = 0; charIndex < stringValue.length(); ++charIndex) {
                        char charAt = stringValue.charAt(charIndex);
                        if (charAt >= 'a' && charAt <= 'z') {
                            setValues.add((byte)Character.toUpperCase(charAt));
                        } else if (charAt >= 'A' && charAt <= 'A') {
                            setValues.add((byte)Character.toLowerCase(charAt));
                        }
                        setValues.add((byte)charAt);
                    }
                    continue block10;
                }
                default: {
                    String message = String.format(TYPE_ERROR, ParseUtils.getTokenName(childNode));
                    throw new ParseException(message);
                }
            }
        }
        return setValues;
    }

    public static Set<Byte> inverseOf(Set<Byte> byteSet) {
        HashSet<Byte> inverseSet = new HashSet<Byte>();
        for (int value = 0; value < 256; ++value) {
            if (byteSet.contains((byte)value)) continue;
            inverseSet.add((byte)value);
        }
        return inverseSet;
    }

    public static String trimString(String str) {
        return str.substring(1, str.length() - 1);
    }

    public static String getTokenName(CommonTree node) {
        return regularExpressionParser.tokenNames[node.getType()];
    }

    public static String getTypeErrorMessage(CommonTree node) {
        return String.format(TYPE_ERROR, ParseUtils.getTokenName(node));
    }
}

