/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.action;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.action.DroidCommand;
import uk.gov.nationalarchives.droid.command.filter.CommandLineFilter;
import uk.gov.nationalarchives.droid.command.filter.DqlFilterParser;
import uk.gov.nationalarchives.droid.command.filter.SimpleFilter;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalConfig;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileManager;
import uk.gov.nationalarchives.droid.report.ReportTransformException;
import uk.gov.nationalarchives.droid.report.ReportTransformerImpl;
import uk.gov.nationalarchives.droid.report.interfaces.Report;
import uk.gov.nationalarchives.droid.report.interfaces.ReportCancelledException;
import uk.gov.nationalarchives.droid.report.interfaces.ReportManager;
import uk.gov.nationalarchives.droid.report.interfaces.ReportRequest;
import uk.gov.nationalarchives.droid.report.interfaces.ReportSpec;
import uk.gov.nationalarchives.droid.report.interfaces.ReportXmlWriter;
import uk.gov.nationalarchives.droid.results.handlers.ProgressObserver;

public class ReportCommand
implements DroidCommand {
    private static final String DROID_REPORT_XML = "DROID Report XML";
    private static final String PDF_FORMAT = "PDF";
    private static final String XHTML_TRANSFORM_LOCATION = "Web page.html.xsl";
    private String[] profiles;
    private ReportManager reportManager;
    private ProfileManager profileManager;
    private ReportXmlWriter reportXmlWriter;
    private String destination;
    private String reportType;
    private DroidGlobalConfig config;
    private String reportOutputType = "pdf";
    private DqlFilterParser dqlFilterParser;
    private CommandLineFilter cliFilter;
    private Log log = LogFactory.getLog(this.getClass());

    @Override
    public void execute() throws CommandExecutionException {
        ArrayList<String> profileIds = new ArrayList<String>();
        SimpleFilter filter = null;
        if (this.cliFilter != null) {
            filter = new SimpleFilter(this.cliFilter.getFilterType());
            for (String dql : this.cliFilter.getFilters()) {
                filter.add(this.dqlFilterParser.parse(dql));
            }
        }
        for (String profileLocation : this.profiles) {
            try {
                ProfileInstance profile = this.profileManager.open(new File(profileLocation), new ProgressObserver(){

                    public void onProgress(Integer progress) {
                    }
                });
                profileIds.add(profile.getUuid());
            }
            catch (IOException e) {
                throw new CommandExecutionException(e);
            }
        }
        ReportRequest request = new ReportRequest();
        request.setProfileIds(profileIds);
        List reportSpecs = this.reportManager.listReportSpecs();
        for (ReportSpec reportSpec : reportSpecs) {
            if (!reportSpec.getName().equals(this.reportType)) continue;
            request.setReportSpec(reportSpec);
            break;
        }
        if (request.getReportSpec() == null) {
            throw new CommandExecutionException(String.format("Report [%s] not found.", this.reportType));
        }
        this.writeReport(request, filter);
        this.profileManager.closeProfile((String)profileIds.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReport(ReportRequest request, Filter optionalFilter) throws CommandExecutionException {
        block12: {
            try {
                Report report = this.reportManager.generateReport(request, optionalFilter, null);
                ReportTransformerImpl transformer = new ReportTransformerImpl();
                transformer.setConfig(this.config);
                String message = String.format("Exporting report as [%s] to: [%s]", this.reportOutputType, this.destination);
                this.log.info((Object)message);
                if (DROID_REPORT_XML.equalsIgnoreCase(this.reportOutputType)) {
                    FileWriter tempReport = new FileWriter(this.destination);
                    this.reportXmlWriter.writeReport(report, (Writer)tempReport);
                    break block12;
                }
                File tempFile = File.createTempFile("report~", ".xml", this.config.getTempDir());
                FileWriter tempReport = new FileWriter(tempFile);
                this.reportXmlWriter.writeReport(report, (Writer)tempReport);
                FileReader reader = new FileReader(tempFile);
                try {
                    if (PDF_FORMAT.equalsIgnoreCase(this.reportOutputType)) {
                        FileOutputStream out = new FileOutputStream(this.destination);
                        transformer.transformToPdf((Reader)reader, XHTML_TRANSFORM_LOCATION, (OutputStream)out);
                        out.close();
                    } else {
                        ReportSpec spec = request.getReportSpec();
                        File xslFile = this.getXSLFile(spec.getXslTransforms());
                        if (xslFile != null) {
                            FileWriter out = new FileWriter(this.destination);
                            transformer.transformUsingXsl((Reader)reader, xslFile, (Writer)out);
                            out.close();
                        }
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (ReportCancelledException e) {
                throw new CommandExecutionException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new CommandExecutionException(e.getMessage(), e);
            }
            catch (ReportTransformException e) {
                throw new CommandExecutionException(e.getMessage(), e);
            }
            catch (TransformerException e) {
                throw new CommandExecutionException(e.getMessage(), e);
            }
        }
    }

    private File getXSLFile(List<File> xslTransforms) {
        for (File file : xslTransforms) {
            String transformName = StringUtils.substringBefore((String)file.getName(), (String)".");
            if (!transformName.equalsIgnoreCase(this.reportOutputType)) continue;
            return file;
        }
        return null;
    }

    public void setProfiles(String[] profileList) {
        this.profiles = profileList;
    }

    String[] getProfiles() {
        return this.profiles;
    }

    public void setProfileManager(ProfileManager profileManager) {
        this.profileManager = profileManager;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    String getDestination() {
        return this.destination;
    }

    public void setReportManager(ReportManager reportManager) {
        this.reportManager = reportManager;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public void setReportOutputType(String reportOutputType) {
        this.reportOutputType = reportOutputType;
    }

    public void setReportXmlWriter(ReportXmlWriter reportXmlWriter) {
        this.reportXmlWriter = reportXmlWriter;
    }

    public void setFilter(CommandLineFilter filter) {
        this.cliFilter = filter;
    }

    public void setDqlFilterParser(DqlFilterParser dqlFilterParser) {
        this.dqlFilterParser = dqlFilterParser;
    }

    public DroidGlobalConfig getConfig() {
        return this.config;
    }

    public void setConfig(DroidGlobalConfig config) {
        this.config = config;
    }
}

