/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import uk.gov.nationalarchives.droid.command.ResultPrinter;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.GZipIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class GZipArchiveContentIdentifier {
    private static final long SIZE = 12L;
    private static final long TIME = 13L;
    private BinarySignatureIdentifier binarySignatureIdentifier;
    private ContainerSignatureDefinitions containerSignatureDefinitions;
    private String path;
    private String slash;
    private String slash1;
    private File tmpDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GZipArchiveContentIdentifier(BinarySignatureIdentifier binarySignatureIdentifier, ContainerSignatureDefinitions containerSignatureDefinitions, String path, String slash, String slash1) {
        GZipArchiveContentIdentifier gZipArchiveContentIdentifier = this;
        synchronized (gZipArchiveContentIdentifier) {
            this.binarySignatureIdentifier = binarySignatureIdentifier;
            this.containerSignatureDefinitions = containerSignatureDefinitions;
            this.path = path;
            this.slash = slash;
            this.slash1 = slash1;
            if (this.tmpDir == null) {
                this.tmpDir = new File(System.getProperty("java.io.tmpdir"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void identify(URI uri, IdentificationRequest request) throws CommandExecutionException {
        String newPath = "gzip:" + this.slash1 + this.path + request.getFileName() + "!" + this.slash;
        this.slash1 = "";
        URI newUri = URI.create(GzipUtils.getUncompressedFilename((String)uri.toString()));
        RequestIdentifier identifier = new RequestIdentifier(newUri);
        RequestMetaData metaData = new RequestMetaData(Long.valueOf(12L), Long.valueOf(13L), uri.getPath());
        GZipIdentificationRequest gzRequest = new GZipIdentificationRequest(metaData, identifier, this.tmpDir);
        GzipCompressorInputStream gzin = null;
        try {
            gzin = new GzipCompressorInputStream((InputStream)new FileInputStream(request.getSourceFile()));
            gzRequest.open((InputStream)gzin);
            IdentificationResultCollection gzResults = this.binarySignatureIdentifier.matchBinarySignatures((IdentificationRequest)gzRequest);
            ResultPrinter resultPrinter = new ResultPrinter(this.binarySignatureIdentifier, this.containerSignatureDefinitions, newPath, this.slash, this.slash1, true);
            resultPrinter.print(gzResults, (IdentificationRequest)gzRequest);
        }
        catch (IOException ioe) {
            System.err.println(ioe + " (" + newPath + ")");
        }
        finally {
            if (gzin != null) {
                try {
                    gzin.close();
                }
                catch (IOException ioe) {
                    throw new CommandExecutionException(ioe.getMessage(), ioe);
                }
            }
        }
    }
}

