/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.file;

import java.io.File;
import java.io.FilenameFilter;

public abstract class FileFilter
extends javax.swing.filechooser.FileFilter
implements java.io.FileFilter,
FilenameFilter {
    public static FileFilter VisibleAll = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return !f.isHidden() && !f.getName().startsWith(".");
        }

        @Override
        public String getDescription() {
            return "All visible files and directories";
        }
    };
    public static FileFilter VisibleFiles = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isFile() && !f.isHidden() && !f.getName().startsWith(".");
        }

        @Override
        public String getDescription() {
            return "All visible files";
        }
    };
    public static FileFilter VisibleDirectories = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory() && !f.isHidden() && !f.getName().startsWith(".");
        }

        @Override
        public String getDescription() {
            return "All visible directories";
        }
    };
    public static FileFilter METSFiles = new FileFilter(){

        @Override
        public boolean accept(File f) {
            String fileNameLowerCase = f.getName().toLowerCase();
            return !f.isHidden() && !fileNameLowerCase.startsWith(".") && fileNameLowerCase.startsWith("mets") && fileNameLowerCase.endsWith(".xml");
        }

        @Override
        public String getDescription() {
            return "METS XML-files";
        }
    };
    public static FileFilter ZIPs = new FileFilter(){

        @Override
        public boolean accept(File f) {
            String fileName = f.getName();
            return !f.isHidden() && !fileName.startsWith(".") && f.isFile() && fileName.toLowerCase().endsWith(".zip");
        }

        @Override
        public String getDescription() {
            return "ZIP-files";
        }
    };
    public static FileFilter METSFilesOrZIPs = new FileFilter(){

        @Override
        public boolean accept(File f) {
            String fileNameLowerCase = f.getName().toLowerCase();
            return !f.isHidden() && !fileNameLowerCase.startsWith(".") && f.isFile() && (fileNameLowerCase.endsWith(".zip") || fileNameLowerCase.startsWith("mets") && fileNameLowerCase.endsWith(".xml"));
        }

        @Override
        public String getDescription() {
            return "METS- or ZIP-files";
        }
    };
    public static FileFilter SIPs = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isHidden() || file.getName().startsWith(".")) {
                return false;
            }
            if (file.isFile()) {
                return false;
            }
            String[] metsFilesWithin = file.list();
            if (metsFilesWithin == null) {
                return false;
            }
            for (String f : metsFilesWithin) {
                if (!f.equalsIgnoreCase("mets.xml")) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "SIP Folders";
        }
    };
    public static FileFilter SIPsOrZIPs = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isHidden() || file.getName().startsWith(".")) {
                return false;
            }
            if (file.isFile()) {
                if (file.getName().toLowerCase().endsWith(".zip")) {
                    return true;
                }
            } else {
                String[] metsFilesWithin = file.list();
                if (metsFilesWithin == null) {
                    return false;
                }
                for (String f : metsFilesWithin) {
                    if (!f.equalsIgnoreCase("mets.xml")) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "SIP Folders or ZIP-Files";
        }
    };

    @Override
    public boolean accept(File dir, String name) {
        return this.accept(new File(dir, name));
    }
}

