/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.file;

import ch.docuteam.tools.os.OperatingSystem;
import ch.docuteam.tools.out.Logger;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipFile;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public abstract class Zipper {
    private static final Charset DefaultZipReadCharset;
    private static Charset ZipReadCharset;

    public static Charset getZipReadCharset() {
        return ZipReadCharset;
    }

    public static void setZipReadCharset(Charset zipReadCharset) {
        ZipReadCharset = zipReadCharset;
    }

    public static void setZipReadCharset(String zipReadCharset) {
        ZipReadCharset = Charset.forName(zipReadCharset);
    }

    public static File zip(String sourcePath) throws IOException {
        return Zipper.zip(sourcePath, sourcePath + ".zip");
    }

    public static File zip(String sourcePath, String zipFilePath, boolean skipTopFolder) throws IOException {
        if (!skipTopFolder) {
            return Zipper.zip(sourcePath, zipFilePath);
        }
        File sourceFile = new File(sourcePath);
        if (!sourceFile.exists()) {
            Logger.getLogger().error("Source file for zipping doesn't exist:" + sourcePath);
            throw new FileNotFoundException(sourcePath);
        }
        if (sourceFile.isFile()) {
            return Zipper.zip(sourcePath, zipFilePath);
        }
        ArrayList<String> subFileNames = new ArrayList<String>();
        for (String fileName : sourceFile.list()) {
            subFileNames.add(sourcePath + "/" + fileName);
        }
        return Zipper.zip(subFileNames.toArray(new String[0]), zipFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zip(String sourcePath, String zipFilePath) throws IOException {
        Logger.getLogger().info("Zipping: " + sourcePath + " Into:" + zipFilePath);
        File sourceFile = new File(sourcePath);
        if (!sourceFile.exists()) {
            Logger.getLogger().error("Source file for zipping doesn't exist:" + sourcePath);
            throw new FileNotFoundException(sourcePath);
        }
        String zipRootDirectory = sourceFile.getParent();
        if (!zipFilePath.endsWith(".zip") && !zipFilePath.endsWith(".ZIP")) {
            zipFilePath = zipFilePath + ".zip";
        }
        new File(zipFilePath).getParentFile().mkdirs();
        try (ZipOutputStream zipOutStream = new ZipOutputStream((OutputStream)new FileOutputStream(zipFilePath));){
            Zipper.zip(zipRootDirectory, sourceFile, zipOutStream);
        }
        return new File(zipFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zip(String sourcePath, String zipFilePath, String newName) throws IOException {
        Logger.getLogger().info("Zipping: " + sourcePath + " Into:" + zipFilePath + " Renaming to:" + newName);
        File sourceFile = new File(sourcePath);
        if (!sourceFile.exists()) {
            Logger.getLogger().error("Source file for zipping doesn't exist:" + sourcePath);
            throw new FileNotFoundException(sourcePath);
        }
        String newSourcePath = sourceFile.getParent() + "/" + newName;
        File newSourceFile = new File(newSourcePath);
        try {
            if (!sourceFile.renameTo(newSourceFile)) {
                throw new IOException("Could not rename File '" + sourcePath + "' to: '" + newSourcePath + "'");
            }
            File file = Zipper.zip(newSourcePath, zipFilePath);
            return file;
        }
        finally {
            if (!newSourceFile.renameTo(sourceFile)) {
                throw new IOException("Could not rename File '" + newSourcePath + "' back to: '" + sourcePath + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zip(String[] sourcePaths, String zipFilePath) throws IOException {
        Logger.getLogger().info("Zipping: " + Arrays.toString(sourcePaths) + " Into:" + zipFilePath);
        if (sourcePaths.length == 0) {
            Logger.getLogger().info("Nothing to zip found");
            return null;
        }
        String zipRootDirectory = new File(sourcePaths[0]).getParent();
        if (!zipFilePath.endsWith(".zip") && !zipFilePath.endsWith(".ZIP")) {
            zipFilePath = zipFilePath + ".zip";
        }
        new File(zipFilePath).getParentFile().mkdirs();
        try (ZipOutputStream zipOutStream = new ZipOutputStream((OutputStream)new FileOutputStream(zipFilePath));){
            for (String sourcePath : sourcePaths) {
                File sourceFile = new File(sourcePath);
                if (!sourceFile.exists()) {
                    Logger.getLogger().error("Source file for zipping doesn't exist:" + sourcePath);
                    throw new FileNotFoundException(sourcePath);
                }
                Zipper.zip(zipRootDirectory, new File(sourcePath), zipOutStream);
            }
        }
        return new File(zipFilePath);
    }

    public static void unzip(String zipFilePath) throws IOException {
        String destPath = ".";
        Integer lastIndexOfFileSeparator = zipFilePath.lastIndexOf("/");
        if (lastIndexOfFileSeparator != -1) {
            destPath = zipFilePath.substring(0, lastIndexOfFileSeparator);
        }
        Zipper.unzip(zipFilePath, destPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String zipFilePath, String destPath) throws IOException {
        Logger.getLogger().info("Unzipping: " + zipFilePath + " Into:" + destPath);
        if (!new File(zipFilePath).exists()) {
            Logger.getLogger().error("Source file for unzipping doesn't exist:" + zipFilePath);
            throw new FileNotFoundException(zipFilePath);
        }
        try (ZipFile zipFile = new ZipFile(zipFilePath, ZipReadCharset);){
            for (ZipEntry entry : Collections.list(zipFile.entries())) {
                Zipper.unzipEntry(zipFile, entry, destPath);
            }
        }
    }

    private static void zip(String zipRootDir, File sourceFile, ZipOutputStream zipOutStream) throws IOException {
        if (sourceFile.isDirectory()) {
            Zipper.zipDirectory(zipRootDir, sourceFile, zipOutStream);
        } else {
            Zipper.zipFile(zipRootDir, sourceFile, zipOutStream);
        }
    }

    private static void zipDirectory(String zipRootDir, File sourceDir, ZipOutputStream zipOutputStream) throws IOException {
        Logger.getLogger().debug("Zipping Folder: " + sourceDir.getPath());
        if (!sourceDir.canRead()) {
            Logger.getLogger().warn("No read access for '" + OperatingSystem.userName() + "' on folder: '" + sourceDir.getPath() + "', skipping.");
            return;
        }
        if (sourceDir.listFiles().length == 0) {
            String relativeSourceDirName = (zipRootDir == null ? sourceDir.getPath() : sourceDir.getPath().replace(zipRootDir + File.separator, "")) + "/";
            if (relativeSourceDirName.charAt(1) == ':') {
                relativeSourceDirName = relativeSourceDirName.replace(":", "");
            }
            relativeSourceDirName = relativeSourceDirName.replace('\\', '/');
            zipOutputStream.putNextEntry(new ZipEntry(relativeSourceDirName));
        }
        for (File file : sourceDir.listFiles()) {
            Zipper.zip(zipRootDir, file, zipOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFile(String zipRootDir, File sourceFile, ZipOutputStream zipOutputStream) throws IOException {
        String relativeSourceFileName;
        Logger.getLogger().debug("Zipping File:   " + sourceFile.getPath());
        if (!sourceFile.canRead()) {
            Logger.getLogger().warn("No read access for '" + OperatingSystem.userName() + "' on file: '" + sourceFile.getPath() + "', skipping.");
            return;
        }
        String string = relativeSourceFileName = zipRootDir == null ? sourceFile.getPath() : sourceFile.getPath().replace(zipRootDir + File.separator, "");
        if (relativeSourceFileName.charAt(1) == ':') {
            relativeSourceFileName = relativeSourceFileName.replace(":", "");
        }
        relativeSourceFileName = relativeSourceFileName.replace('\\', '/');
        zipOutputStream.putNextEntry(new ZipEntry(relativeSourceFileName));
        BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(sourceFile), 65536);
        try {
            int i;
            byte[] data = new byte[65536];
            while ((i = fileInputStream.read(data, 0, 65536)) > 0) {
                zipOutputStream.write(data, 0, i);
            }
        }
        finally {
            zipOutputStream.closeEntry();
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzipEntry(ZipFile zipFile, ZipEntry zipEntry, String destDir) throws IOException {
        File file = new File(destDir, zipEntry.getName());
        if (zipEntry.isDirectory()) {
            Logger.getLogger().debug("Unzipping Folder: " + zipEntry.getName());
            file.mkdirs();
        } else {
            Logger.getLogger().debug("Unzipping File:   " + zipEntry.getName());
            new File(file.getParent()).mkdirs();
            InputStream zipEntryInputStream = zipFile.getInputStream(zipEntry);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                int i;
                byte[] data = new byte[65536];
                while ((i = zipEntryInputStream.read(data)) != -1) {
                    ((OutputStream)fileOutputStream).write(data, 0, i);
                }
            }
            finally {
                ((OutputStream)fileOutputStream).close();
                zipEntryInputStream.close();
            }
        }
    }

    static {
        ZipReadCharset = DefaultZipReadCharset = Charset.forName(System.getProperty("zip.encoding", Charset.defaultCharset().name()));
    }
}

