/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.gui;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LimitedTextField
extends JTextField {
    public LimitedTextField(Integer limit, String initialText) {
        this(limit);
        this.setText(initialText);
    }

    public LimitedTextField(final Integer limit) {
        this.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
                if (str == null) {
                    return;
                }
                if (this.getLength() + str.length() <= limit) {
                    super.insertString(offset, str, attr);
                }
            }
        });
    }
}

