/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.automata.nfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.domesdaybook.automata.Transition;
import net.domesdaybook.automata.nfa.NfaState;
import net.domesdaybook.automata.nfa.NfaTransitions;
import net.domesdaybook.object.copy.DeepCopy;

public class NfaTransitionsList
implements NfaTransitions {
    private final List<Transition> transitions;

    public NfaTransitionsList() {
        this.transitions = new ArrayList<Transition>();
    }

    public NfaTransitionsList(Collection<Transition> transitions) {
        this.transitions = new ArrayList<Transition>(transitions);
    }

    public NfaTransitionsList(NfaTransitionsList other) {
        this.transitions = new ArrayList<Transition>(other.transitions);
    }

    @Override
    public void addTransition(Transition transition) {
        this.transitions.add(transition);
    }

    @Override
    public final Set<NfaState> getStatesForByte(byte theByte) {
        HashSet<NfaState> states = new HashSet<NfaState>();
        for (Transition transition : this.transitions) {
            NfaState stateForByte = (NfaState)transition.getStateForByte(theByte);
            if (stateForByte == null) continue;
            states.add(stateForByte);
        }
        return states;
    }

    @Override
    public final int size() {
        return this.transitions.size();
    }

    @Override
    public List<Transition> getTransitions() {
        return this.transitions;
    }

    public NfaTransitionsList deepCopy() {
        HashMap oldToNewObjects = new HashMap();
        return this.deepCopy((Map)oldToNewObjects);
    }

    @Override
    public NfaTransitionsList deepCopy(Map<DeepCopy, DeepCopy> oldToNewObjects) {
        NfaTransitionsList copy = (NfaTransitionsList)oldToNewObjects.get(this);
        if (copy == null) {
            copy = new NfaTransitionsList();
            oldToNewObjects.put(this, copy);
            for (Transition transition : this.transitions) {
                Transition transitionCopy = (Transition)transition.deepCopy(oldToNewObjects);
                copy.transitions.add(transitionCopy);
            }
        }
        return copy;
    }
}

