/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid6;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.domesdaybook.expression.compiler.sequence.SequenceMatcherCompiler;
import net.domesdaybook.expression.parser.ParseException;
import net.domesdaybook.matcher.sequence.SequenceMatcher;
import net.domesdaybook.matcher.sequence.searcher.BoyerMooreHorspoolSearcher;
import net.domesdaybook.matcher.sequence.searcher.SequenceMatcherSearcher;
import uk.gov.nationalarchives.droid.core.signature.ByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid6.ByteSequence;
import uk.gov.nationalarchives.droid.core.signature.droid6.FragmentRewriter;
import uk.gov.nationalarchives.droid.core.signature.droid6.LeftFragment;
import uk.gov.nationalarchives.droid.core.signature.droid6.RightFragment;
import uk.gov.nationalarchives.droid.core.signature.droid6.Shift;
import uk.gov.nationalarchives.droid.core.signature.droid6.SideFragment;
import uk.gov.nationalarchives.droid.core.signature.xml.SimpleElement;

public class SubSequence
extends SimpleElement {
    private static final String SEQUENCE_PARSE_ERROR = "The signature sub-sequence [%s] could not be parsed. The error returned was [%s]";
    private static final boolean EXPRESSION_BEFORE_GAPS = true;
    private static final boolean GAPS_BEFORE_EXPRESSION = false;
    private int minSeqOffset;
    private int maxSeqOffset;
    private int minLeftFragmentLength;
    private int maxLeftFragmentLength;
    private int minRightFragmentLength;
    private int maxRightFragmentLength;
    private int numLeftFragmentPositions;
    private int numRightFragmentPositions;
    private boolean fullFileScan;
    private List<LeftFragment> leftFragments = new ArrayList<LeftFragment>();
    private List<RightFragment> rightFragments = new ArrayList<RightFragment>();
    private SequenceMatcher matcher;
    private SequenceMatcherSearcher searcher;
    private final List<List<SideFragment>> orderedLeftFragments = new ArrayList<List<SideFragment>>();
    private final List<List<SideFragment>> orderedRightFragments = new ArrayList<List<SideFragment>>();
    private boolean backwardsSearch;
    private boolean isInvalidSubSequence;

    private LeftFragment getRawLeftFragment(int theIndex) {
        return this.leftFragments.get(theIndex);
    }

    private RightFragment getRawRightFragment(int theIndex) {
        return this.rightFragments.get(theIndex);
    }

    public final void addLeftFragment(LeftFragment leftFrag) {
        this.leftFragments.add(leftFrag);
    }

    public final void addRightFragment(RightFragment rightFrag) {
        this.rightFragments.add(rightFrag);
    }

    @Deprecated
    public final void setShift(Shift theShift) {
    }

    @Deprecated
    public final void setDefaultShift(String theValue) {
    }

    public final void setSequence(String seq) {
        try {
            String transformedSequence = FragmentRewriter.rewriteFragment(seq);
            SequenceMatcherCompiler compiler = new SequenceMatcherCompiler();
            this.matcher = (SequenceMatcher)compiler.compile(transformedSequence);
            this.searcher = new BoyerMooreHorspoolSearcher(this.matcher);
        }
        catch (ParseException ex) {
            String warning = String.format(SEQUENCE_PARSE_ERROR, seq, ex.getMessage());
            this.getLog().warn((Object)warning);
            this.isInvalidSubSequence = true;
        }
    }

    public final void setMinSeqOffset(int theOffset) {
        this.minSeqOffset = theOffset;
        if (this.maxSeqOffset < this.minSeqOffset) {
            this.maxSeqOffset = this.minSeqOffset;
        }
    }

    public final void setMaxSeqOffset(int theOffset) {
        this.maxSeqOffset = theOffset;
        if (this.maxSeqOffset < this.minSeqOffset) {
            this.maxSeqOffset = this.minSeqOffset;
        }
    }

    @Deprecated
    public void setMinFragLength(int theLength) {
    }

    @Override
    public final void setAttributeValue(String name, String value) {
        if ("SubSeqMinOffset".equals(name)) {
            this.setMinSeqOffset(Integer.parseInt(value));
        } else if ("SubSeqMaxOffset".equals(name)) {
            this.setMaxSeqOffset(Integer.parseInt(value));
        } else if ("MinFragLength".equals(name)) {
            this.setMinFragLength(-1);
        } else if (!"Position".equals(name)) {
            this.unknownAttributeWarning(name, this.getElementName());
        }
    }

    public final int getNumFragmentPositions(boolean leftFrag) {
        return leftFrag ? this.numLeftFragmentPositions : this.numRightFragmentPositions;
    }

    public final int getNumAlternativeFragments(boolean leftFrag, int thePosition) {
        return leftFrag ? this.orderedLeftFragments.get(thePosition - 1).size() : this.orderedRightFragments.get(thePosition - 1).size();
    }

    public final SideFragment getFragment(boolean leftFrag, int thePosition, int alternateIndex) {
        return leftFrag ? this.orderedLeftFragments.get(thePosition - 1).get(alternateIndex) : this.orderedRightFragments.get(thePosition - 1).get(alternateIndex);
    }

    public final int getNumBytes() {
        return this.matcher == null ? 0 : this.matcher.length();
    }

    public final int getMinSeqOffset() {
        return this.minSeqOffset;
    }

    public final int getMaxSeqOffset() {
        return this.maxSeqOffset;
    }

    public final void prepareForUse(boolean reverseOrder, boolean fullScan) {
        this.backwardsSearch = reverseOrder;
        this.fullFileScan = fullScan;
        this.processSequenceFragments();
    }

    private void processSequenceFragments() {
        SideFragment frag;
        int maxFragSize;
        int minFragSize;
        int position;
        ArrayList<SideFragment> newList;
        StringBuilder expression;
        boolean allFragmentsLengthOne;
        int noOfFragments;
        int fragPos;
        int currentPosition;
        int i;
        int numPositions = 0;
        for (i = 0; i < this.leftFragments.size(); ++i) {
            int currentPosition2 = this.getRawLeftFragment(i).getPosition();
            if (currentPosition2 <= numPositions) continue;
            numPositions = currentPosition2;
        }
        for (i = 0; i < numPositions; ++i) {
            ArrayList alternativeFragments = new ArrayList();
            this.orderedLeftFragments.add(alternativeFragments);
        }
        for (i = 0; i < this.leftFragments.size(); ++i) {
            LeftFragment fragment = this.getRawLeftFragment(i);
            currentPosition = fragment.getPosition();
            this.orderedLeftFragments.get(currentPosition - 1).add(fragment);
        }
        for (fragPos = 0; fragPos < this.orderedLeftFragments.size(); ++fragPos) {
            List<SideFragment> fragmentsToMatch = this.orderedLeftFragments.get(fragPos);
            noOfFragments = fragmentsToMatch.size();
            if (noOfFragments <= 1) continue;
            allFragmentsLengthOne = true;
            SideFragment frag2 = null;
            expression = new StringBuilder();
            expression.append('[');
            for (int fragmentIndex = 0; fragmentIndex < noOfFragments; ++fragmentIndex) {
                frag2 = fragmentsToMatch.get(fragmentIndex);
                if (frag2.getNumBytes() > 1) {
                    allFragmentsLengthOne = false;
                    break;
                }
                expression.append(frag2.toRegularExpression(false));
            }
            if (!allFragmentsLengthOne || frag2 == null) continue;
            LeftFragment newFrag = new LeftFragment();
            newFrag.setPosition(frag2.getPosition());
            newFrag.setMinOffset(frag2.getMinOffset());
            newFrag.setMaxOffset(frag2.getMaxOffset());
            expression.append(']');
            newFrag.setFragment(expression.toString());
            newList = new ArrayList<SideFragment>();
            newList.add(newFrag);
            this.orderedLeftFragments.set(fragPos, newList);
        }
        this.minLeftFragmentLength = 0;
        this.maxLeftFragmentLength = 0;
        for (position = 0; position < this.orderedLeftFragments.size(); ++position) {
            List<SideFragment> fragmentList = this.orderedLeftFragments.get(position);
            minFragSize = Integer.MAX_VALUE;
            maxFragSize = 0;
            for (int fragmentIndex = 0; fragmentIndex < fragmentList.size(); ++fragmentIndex) {
                frag = fragmentList.get(fragmentIndex);
                int fragMinSpace = frag.getNumBytes() + frag.getMinOffset();
                int fragMaxSpace = frag.getNumBytes() + frag.getMaxOffset();
                if (fragMinSpace < minFragSize) {
                    minFragSize = fragMinSpace;
                }
                if (fragMaxSpace <= maxFragSize) continue;
                maxFragSize = fragMaxSpace;
            }
            this.minLeftFragmentLength += minFragSize;
            this.maxLeftFragmentLength += maxFragSize;
        }
        this.numLeftFragmentPositions = this.orderedLeftFragments.size();
        this.leftFragments = null;
        numPositions = 0;
        for (i = 0; i < this.rightFragments.size(); ++i) {
            int currentPosition3 = this.getRawRightFragment(i).getPosition();
            if (currentPosition3 <= numPositions) continue;
            numPositions = currentPosition3;
        }
        for (i = 0; i < numPositions; ++i) {
            ArrayList alternativeFragments = new ArrayList();
            this.orderedRightFragments.add(alternativeFragments);
        }
        for (i = 0; i < this.rightFragments.size(); ++i) {
            RightFragment fragment = this.getRawRightFragment(i);
            currentPosition = fragment.getPosition();
            this.orderedRightFragments.get(currentPosition - 1).add(fragment);
        }
        for (fragPos = 0; fragPos < this.orderedRightFragments.size(); ++fragPos) {
            List<SideFragment> fragmentsToMatch = this.orderedRightFragments.get(fragPos);
            noOfFragments = fragmentsToMatch.size();
            if (noOfFragments <= 1) continue;
            allFragmentsLengthOne = true;
            SideFragment frag3 = null;
            expression = new StringBuilder();
            expression.append('[');
            for (int fragmentIndex = 0; fragmentIndex < noOfFragments; ++fragmentIndex) {
                frag3 = fragmentsToMatch.get(fragmentIndex);
                if (frag3.getNumBytes() > 1) {
                    allFragmentsLengthOne = false;
                    break;
                }
                expression.append(frag3.toRegularExpression(false));
            }
            if (!allFragmentsLengthOne || frag3 == null) continue;
            RightFragment newFrag = new RightFragment();
            newFrag.setPosition(frag3.getPosition());
            newFrag.setMinOffset(frag3.getMinOffset());
            newFrag.setMaxOffset(frag3.getMaxOffset());
            expression.append(']');
            newFrag.setFragment(expression.toString());
            newList = new ArrayList();
            newList.add(newFrag);
            this.orderedRightFragments.set(fragPos, newList);
        }
        this.minRightFragmentLength = 0;
        this.maxRightFragmentLength = 0;
        for (position = 0; position < this.orderedRightFragments.size(); ++position) {
            List<SideFragment> fragmentList = this.orderedRightFragments.get(position);
            minFragSize = Integer.MAX_VALUE;
            maxFragSize = 0;
            for (int fragmentIndex = 0; fragmentIndex < fragmentList.size(); ++fragmentIndex) {
                frag = fragmentList.get(fragmentIndex);
                int fragMinSpace = frag.getNumBytes() + frag.getMinOffset();
                int fragMaxSpace = frag.getNumBytes() + frag.getMaxOffset();
                if (fragMinSpace < minFragSize) {
                    minFragSize = fragMinSpace;
                }
                if (fragMaxSpace <= maxFragSize) continue;
                maxFragSize = fragMaxSpace;
            }
            this.minRightFragmentLength += minFragSize;
            this.maxRightFragmentLength += maxFragSize;
        }
        this.numRightFragmentPositions = this.orderedRightFragments.size();
        this.rightFragments = null;
        this.isInvalidSubSequence = this.isInvalidSubSequence ? true : this.checkForInvalidFragments();
    }

    public boolean isInvalidSubSequence() {
        return this.isInvalidSubSequence;
    }

    private boolean checkForInvalidFragments() {
        return this.checkFragmentList(this.orderedLeftFragments) || this.checkFragmentList(this.orderedRightFragments);
    }

    private boolean checkFragmentList(List<List<SideFragment>> orderedFragmentList) {
        for (List<SideFragment> fragmentList : orderedFragmentList) {
            for (SideFragment fragment : fragmentList) {
                if (!fragment.isInvalidFragment()) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean findSequenceFromPosition(long position, ByteReader targetFile, long maxBytesToScan, boolean bofSubsequence, boolean eofSubsequence) {
        boolean entireSequenceFound;
        block17: {
            entireSequenceFound = false;
            try {
                long endSearchWindow;
                boolean hasLeftFragments = !this.orderedLeftFragments.isEmpty();
                boolean hasRightFragments = !this.orderedRightFragments.isEmpty();
                long lastBytePositionInFile = targetFile.getNumBytes() - 1L;
                int matchLength = this.matcher.length();
                int lastBytePositionInAnchor = matchLength - 1;
                long firstPossibleBytePosition = this.minLeftFragmentLength;
                long lastPossibleBytePosition = lastBytePositionInFile - (long)this.minRightFragmentLength;
                net.domesdaybook.reader.ByteReader reader = targetFile.getReader();
                if (this.backwardsSearch) {
                    long endSearchWindow2;
                    long maximumPossibleStartingPosition = position - (long)this.minRightFragmentLength - (long)lastBytePositionInAnchor;
                    long startSearchWindow = maximumPossibleStartingPosition - (long)this.getMinSeqOffset();
                    int rightFragmentWindow = this.maxRightFragmentLength - this.minRightFragmentLength;
                    long l = endSearchWindow2 = this.fullFileScan ? 0L : maximumPossibleStartingPosition - (long)this.getMaxSeqOffset() - (long)rightFragmentWindow;
                    if (maxBytesToScan > 0L && endSearchWindow2 < lastBytePositionInFile - maxBytesToScan) {
                        endSearchWindow2 = lastBytePositionInFile - maxBytesToScan;
                    }
                    if (startSearchWindow > lastPossibleBytePosition) {
                        return false;
                    }
                    if (endSearchWindow2 < firstPossibleBytePosition) {
                        endSearchWindow2 = firstPossibleBytePosition;
                    }
                    for (long matchPosition = startSearchWindow; matchPosition >= endSearchWindow2 && (matchPosition = this.searcher.searchBackwards(reader, matchPosition, endSearchWindow2)) != -1L; --matchPosition) {
                        boolean matchFound = true;
                        if (hasRightFragments) {
                            long[] rightFragmentPositions = this.bytePosForRightFragments(reader, matchPosition + (long)matchLength, targetFile.getFileMarker(), 1, 0);
                            boolean bl = matchFound = rightFragmentPositions.length > 0;
                        }
                        if (!matchFound) continue;
                        if (hasLeftFragments) {
                            long[] leftFragmentPositions = this.bytePosForLeftFragments(reader, 0L, matchPosition - 1L, -1, 0);
                            matchFound = leftFragmentPositions.length > 0;
                            long l2 = matchPosition = matchFound ? leftFragmentPositions[0] : matchPosition;
                        }
                        if (!matchFound) continue;
                        targetFile.setFileMarker(matchPosition - 1L);
                        entireSequenceFound = true;
                        break block17;
                    }
                    break block17;
                }
                long minimumPossibleStartingPosition = position + (long)this.minLeftFragmentLength + (long)lastBytePositionInAnchor;
                long startSearchWindow = minimumPossibleStartingPosition + (long)this.getMinSeqOffset();
                int leftFragmentWindow = this.maxLeftFragmentLength - this.minLeftFragmentLength;
                long l = endSearchWindow = this.fullFileScan ? lastPossibleBytePosition : minimumPossibleStartingPosition + (long)this.getMaxSeqOffset() + (long)leftFragmentWindow;
                if (maxBytesToScan > 0L && endSearchWindow > maxBytesToScan) {
                    endSearchWindow = maxBytesToScan;
                }
                if (startSearchWindow < firstPossibleBytePosition) {
                    return false;
                }
                if (endSearchWindow > lastPossibleBytePosition) {
                    endSearchWindow = lastPossibleBytePosition;
                }
                for (long matchPosition = startSearchWindow; matchPosition <= endSearchWindow && (matchPosition = this.searcher.searchForwards(reader, matchPosition, endSearchWindow)) != -1L; ++matchPosition) {
                    boolean matchFound = true;
                    if (hasLeftFragments) {
                        long[] leftFragmentPositions = this.bytePosForLeftFragments(reader, targetFile.getFileMarker(), matchPosition - (long)matchLength, -1, 0);
                        boolean bl = matchFound = leftFragmentPositions.length > 0;
                        if (matchFound && bofSubsequence && leftFragmentPositions[0] > (long)this.maxSeqOffset) {
                            matchFound = false;
                        }
                    }
                    if (!matchFound) continue;
                    if (hasRightFragments) {
                        long[] rightFragmentPositions = this.bytePosForRightFragments(reader, matchPosition + 1L, lastBytePositionInFile, 1, 0);
                        boolean bl = matchFound = rightFragmentPositions.length > 0;
                        if (matchFound && eofSubsequence && rightFragmentPositions[0] > (long)this.maxSeqOffset) {
                            matchFound = false;
                        }
                        long l3 = matchPosition = matchFound ? rightFragmentPositions[0] : matchPosition;
                    }
                    if (!matchFound) continue;
                    targetFile.setFileMarker(matchPosition + 1L);
                    entireSequenceFound = true;
                    break;
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.getLog().debug((Object)e.getMessage());
            }
        }
        return entireSequenceFound;
    }

    private long[] bytePosForLeftFragments(net.domesdaybook.reader.ByteReader bytes, long leftBytePos, long rightBytePos, int searchDirection, int offsetRange) {
        int posLoopStart;
        long startPos;
        boolean leftFrag = true;
        int numFragPos = this.numLeftFragmentPositions;
        if (searchDirection == 1) {
            startPos = leftBytePos;
            posLoopStart = numFragPos;
        } else {
            startPos = rightBytePos;
            posLoopStart = 1;
        }
        int totalNumOptions = offsetRange + 1;
        for (int iFragPos = 1; iFragPos <= numFragPos; ++iFragPos) {
            totalNumOptions *= this.getNumAlternativeFragments(true, iFragPos);
        }
        long[] markerPos = new long[totalNumOptions];
        for (int iOffset = 0; iOffset <= offsetRange; ++iOffset) {
            markerPos[iOffset] = startPos + (long)(iOffset * searchDirection);
        }
        int numOptions = 1 + offsetRange;
        boolean seqNotFound = false;
        for (int iFragPos = posLoopStart; !seqNotFound && iFragPos <= numFragPos && iFragPos >= 1; iFragPos -= searchDirection) {
            int iOption;
            List<SideFragment> fragmentsAtPosition = this.orderedLeftFragments.get(iFragPos - 1);
            int numAltFrags = fragmentsAtPosition.size();
            long[] tempEndPos = new long[numAltFrags * numOptions];
            int numEndPos = 0;
            for (iOption = 0; iOption < numOptions; ++iOption) {
                for (int iAlt = 0; iAlt < numAltFrags; ++iAlt) {
                    SideFragment fragment = fragmentsAtPosition.get(iAlt);
                    long tempFragEnd = searchDirection == 1 ? this.endBytePosForSeqFrag(bytes, markerPos[iOption], rightBytePos, true, searchDirection, iFragPos, fragment) : this.endBytePosForSeqFrag(bytes, leftBytePos, markerPos[iOption], true, searchDirection, iFragPos, fragment);
                    if (tempFragEnd <= -1L) continue;
                    tempEndPos[numEndPos] = tempFragEnd + (long)searchDirection;
                    ++numEndPos;
                }
            }
            if (numEndPos == 0) {
                seqNotFound = true;
                continue;
            }
            numOptions = 0;
            for (iOption = 0; iOption < numEndPos; ++iOption) {
                boolean addEndPos = true;
                for (int iMarker = 0; iMarker < numOptions; ++iMarker) {
                    if (markerPos[iMarker] != tempEndPos[iOption]) continue;
                    addEndPos = false;
                    break;
                }
                if (!addEndPos) continue;
                markerPos[numOptions] = tempEndPos[iOption];
                ++numOptions;
            }
        }
        if (seqNotFound) {
            return new long[0];
        }
        long[] outArray = new long[numOptions];
        if (searchDirection < 0) {
            for (int iOption = 0; iOption < numOptions; ++iOption) {
                markerPos[iOption] = -markerPos[iOption];
            }
        }
        Arrays.sort(markerPos, 0, numOptions);
        if (searchDirection < 0) {
            for (int iOption = 0; iOption < numOptions; ++iOption) {
                markerPos[iOption] = -markerPos[iOption];
            }
        }
        System.arraycopy(markerPos, 0, outArray, 0, numOptions);
        int iOption = 0;
        while (iOption < numOptions) {
            int n = iOption++;
            outArray[n] = outArray[n] - (long)searchDirection;
        }
        return outArray;
    }

    private long[] bytePosForRightFragments(net.domesdaybook.reader.ByteReader bytes, long leftBytePos, long rightBytePos, int searchDirection, int offsetRange) {
        boolean leftFrag = false;
        long startPos = leftBytePos;
        int posLoopStart = 1;
        int numFragPos = this.numRightFragmentPositions;
        if (searchDirection == -1) {
            startPos = rightBytePos;
            posLoopStart = numFragPos;
        }
        int totalNumOptions = offsetRange + 1;
        for (int iFragPos = 1; iFragPos <= numFragPos; ++iFragPos) {
            totalNumOptions *= this.getNumAlternativeFragments(false, iFragPos);
        }
        long[] markerPos = new long[totalNumOptions];
        for (int iOffset = 0; iOffset <= offsetRange; ++iOffset) {
            markerPos[iOffset] = startPos + (long)(iOffset * searchDirection);
        }
        int numOptions = 1 + offsetRange;
        boolean seqNotFound = false;
        for (int iFragPos = posLoopStart; !seqNotFound && iFragPos <= numFragPos && iFragPos >= 1; iFragPos += searchDirection) {
            int iOption;
            List<SideFragment> fragmentsAtPosition = this.orderedRightFragments.get(iFragPos - 1);
            int numAltFrags = fragmentsAtPosition.size();
            long[] tempEndPos = new long[numAltFrags * numOptions];
            int numEndPos = 0;
            for (iOption = 0; iOption < numOptions; ++iOption) {
                for (int iAlt = 0; iAlt < numAltFrags; ++iAlt) {
                    SideFragment fragment = fragmentsAtPosition.get(iAlt);
                    long tempFragEnd = searchDirection == -1 ? this.endBytePosForSeqFrag(bytes, leftBytePos, markerPos[iOption], false, searchDirection, iFragPos, fragment) : this.endBytePosForSeqFrag(bytes, markerPos[iOption], rightBytePos, false, searchDirection, iFragPos, fragment);
                    if (tempFragEnd <= -1L) continue;
                    tempEndPos[numEndPos] = tempFragEnd + (long)searchDirection;
                    ++numEndPos;
                }
            }
            if (numEndPos == 0) {
                seqNotFound = true;
                continue;
            }
            numOptions = 0;
            for (iOption = 0; iOption < numEndPos; ++iOption) {
                boolean addEndPos = true;
                for (int iMarker = 0; iMarker < numOptions; ++iMarker) {
                    if (markerPos[iMarker] != tempEndPos[iOption]) continue;
                    addEndPos = false;
                    break;
                }
                if (!addEndPos) continue;
                markerPos[numOptions] = tempEndPos[iOption];
                ++numOptions;
            }
        }
        if (seqNotFound) {
            return new long[0];
        }
        long[] outArray = new long[numOptions];
        if (searchDirection < 0) {
            for (int iOption = 0; iOption < numOptions; ++iOption) {
                markerPos[iOption] = -markerPos[iOption];
            }
        }
        Arrays.sort(markerPos, 0, numOptions);
        if (searchDirection < 0) {
            for (int iOption = 0; iOption < numOptions; ++iOption) {
                markerPos[iOption] = -markerPos[iOption];
            }
        }
        System.arraycopy(markerPos, 0, outArray, 0, numOptions);
        int iOption = 0;
        while (iOption < numOptions) {
            int n = iOption++;
            outArray[n] = outArray[n] - (long)searchDirection;
        }
        return outArray;
    }

    private long endBytePosForSeqFrag(net.domesdaybook.reader.ByteReader bytes, long leftEndBytePos, long rightEndBytePos, boolean leftFrag, int searchDirection, int fragPos, SideFragment fragment) {
        long lastStartPosInFile;
        long lastStartPosInFile2;
        long lastStartPosInFile1;
        long startPosInFile;
        int maxOffset;
        int minOffset;
        int byteOffset;
        long endPosInFile = -1L;
        long searchDirectionL = searchDirection;
        int numBytes = fragment.getNumBytes();
        int n = byteOffset = searchDirection == 1 ? 0 : numBytes - 1;
        if (leftFrag && searchDirection == -1) {
            minOffset = fragment.getMinOffset();
            maxOffset = fragment.getMaxOffset();
        } else if (!leftFrag && searchDirection == 1) {
            minOffset = fragment.getMinOffset();
            maxOffset = fragment.getMaxOffset();
        } else if (fragPos < this.getNumFragmentPositions(leftFrag)) {
            SideFragment nextFragment = this.getFragment(leftFrag, fragPos + 1, 0);
            minOffset = nextFragment.getMinOffset();
            maxOffset = nextFragment.getMaxOffset();
        } else {
            minOffset = 0;
            maxOffset = 0;
        }
        if (searchDirection == -1) {
            startPosInFile = rightEndBytePos - (long)minOffset;
            lastStartPosInFile1 = leftEndBytePos + (long)numBytes - 1L;
            lastStartPosInFile2 = rightEndBytePos - (long)maxOffset;
            lastStartPosInFile = lastStartPosInFile1 < lastStartPosInFile2 ? lastStartPosInFile2 : lastStartPosInFile1;
        } else {
            startPosInFile = leftEndBytePos + (long)minOffset;
            lastStartPosInFile1 = rightEndBytePos - (long)numBytes + 1L;
            lastStartPosInFile2 = leftEndBytePos + (long)maxOffset;
            long l = lastStartPosInFile = lastStartPosInFile1 < lastStartPosInFile2 ? lastStartPosInFile1 : lastStartPosInFile2;
        }
        while (searchDirectionL * (lastStartPosInFile - startPosInFile) >= 0L) {
            if (fragment.matchesBytes(bytes, startPosInFile - (long)byteOffset)) {
                endPosInFile = startPosInFile + (long)numBytes * searchDirectionL - searchDirectionL;
                break;
            }
            startPosInFile += searchDirectionL;
        }
        return endPosInFile;
    }

    private String getFragmentAlternativesAsRegularExpression(boolean prettyPrint, int positionIndex, List<SideFragment> fragments) {
        StringBuffer regularExpression = new StringBuffer();
        regularExpression.append(prettyPrint ? " (" : "(");
        int lastAlternate = fragments.size();
        for (int alternateIndex = 0; alternateIndex < lastAlternate; ++alternateIndex) {
            if (alternateIndex > 0) {
                regularExpression.append("|");
            }
            SideFragment fragment = fragments.get(alternateIndex);
            regularExpression.append(fragment.toRegularExpression(prettyPrint));
        }
        regularExpression.append(prettyPrint ? ") " : ")");
        return regularExpression.toString();
    }

    private void appendFragmentstoRegularExpression(boolean prettyPrint, StringBuffer regularExpression, boolean expressionFirst, int positionIndex, List<SideFragment> fragments) {
        SideFragment fragment = fragments.get(0);
        int minFragmentOffset = fragment.getMinOffset();
        int maxFragmentOffset = fragment.getMaxOffset();
        String fragmentExpression = fragments.size() > 1 ? this.getFragmentAlternativesAsRegularExpression(prettyPrint, positionIndex, fragments) : fragment.toRegularExpression(prettyPrint);
        ByteSequence.appendBoundedGapExpression(prettyPrint, expressionFirst, regularExpression, fragmentExpression, minFragmentOffset, maxFragmentOffset);
    }

    public final String toRegularExpression(boolean prettyPrint) {
        List<SideFragment> fragments;
        int positionIndex;
        StringBuffer regularExpression = new StringBuffer();
        for (positionIndex = this.numLeftFragmentPositions; positionIndex > 0; --positionIndex) {
            fragments = this.orderedLeftFragments.get(positionIndex - 1);
            this.appendFragmentstoRegularExpression(prettyPrint, regularExpression, true, positionIndex, fragments);
        }
        regularExpression.append(this.matcher.toRegularExpression(prettyPrint));
        for (positionIndex = 1; positionIndex <= this.numRightFragmentPositions; ++positionIndex) {
            fragments = this.orderedRightFragments.get(positionIndex - 1);
            this.appendFragmentstoRegularExpression(prettyPrint, regularExpression, false, positionIndex, fragments);
        }
        return regularExpression.toString();
    }
}

