/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.exception;

import ch.docuteam.tools.exception.Exception;
import ch.docuteam.tools.translations.I18N;
import java.util.List;
import java.util.Vector;

public abstract class ExceptionCollector {
    private static List<Exception> All = new Vector<Exception>();

    static void add(Exception e) {
        All.add(e);
    }

    public static Integer size() {
        return All.size();
    }

    public static Exception get(Integer i) {
        return All.get(i);
    }

    public static List<Exception> getAll() {
        return All;
    }

    public static String getAllMessages() {
        if (All.isEmpty()) {
            return "[ExceptionCollector(empty)]";
        }
        StringBuilder stringBuilder = new StringBuilder("[ExceptionCollector(").append(All.size()).append("):");
        for (Exception e : All) {
            stringBuilder.append("\n\t").append(e.getMessage());
        }
        return stringBuilder.append("\n]").toString();
    }

    public static String getAllTranslatedMessages(String noExceptionMessageKey, String exceptionMessagePrefixKey) {
        if (All.isEmpty()) {
            return I18N.translate(noExceptionMessageKey);
        }
        StringBuilder stringBuilder = new StringBuilder(I18N.translate(exceptionMessagePrefixKey)).append(All.size()).append("):");
        for (Exception e : All) {
            if (e.getExceptionType() != null) {
                stringBuilder.append("\n\t").append(I18N.translateAndFormat(e.getExceptionType(), e.getExceptionCause()));
                continue;
            }
            if (e.getException() != null) {
                String exceptionType = e.getException().getClass().getName();
                String exceptionCause = e.getException().getMessage();
                stringBuilder.append("\n\t").append(I18N.translateAndFormat(exceptionType, exceptionCause));
                continue;
            }
            stringBuilder.append("\n\t").append(e.getDescription());
        }
        return stringBuilder.append("\n]").toString();
    }

    public static String getAllToString() {
        if (All.isEmpty()) {
            return "[ExceptionCollector(empty)]";
        }
        StringBuilder stringBuilder = new StringBuilder("[ExceptionCollector(").append(All.size()).append("):");
        for (Exception e : All) {
            stringBuilder.append("\n\t").append(e.toString());
        }
        return stringBuilder.append("\n]").toString();
    }

    @Deprecated
    public static String getMessageAll() {
        if (All.isEmpty()) {
            return "[ExceptionCollector(empty)]";
        }
        StringBuilder stringBuilder = new StringBuilder("[ExceptionCollector(").append(All.size()).append("):");
        for (Exception e : All) {
            stringBuilder.append("\n\t").append(e.getMessage());
        }
        return stringBuilder.append("\n]").toString();
    }

    public static void printStackTrace() {
        if (All.isEmpty()) {
            System.err.println("ExceptionCollector(empty)");
        } else {
            System.err.println("ExceptionCollector:");
            int i = 1;
            for (Exception e : All) {
                System.err.print("#");
                System.err.print(i);
                System.err.print(":");
                System.err.println();
                e.printStackTrace();
                ++i;
            }
        }
    }

    public static void clear() {
        All = new Vector<Exception>();
    }

    public static Boolean isEmpty() {
        return All.isEmpty();
    }

    public static String toStringAll() {
        if (All.isEmpty()) {
            return "[ExceptionCollector(empty)]";
        }
        StringBuilder stringBuilder = new StringBuilder("[ExceptionCollector(").append(All.size()).append("):");
        for (Exception e : All) {
            stringBuilder.append("\n\t").append(e.toString());
        }
        return stringBuilder.append("\n]").toString();
    }

    public static void systemOut() {
        System.out.println(ExceptionCollector.toStringAll());
    }
}

