/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.file;

import ch.docuteam.tools.file.ResourceUtil;
import ch.docuteam.tools.os.EnvironmentVariable;
import ch.docuteam.tools.out.Logger;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.RepInfo;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;

public abstract class MetadataProviderJHOVE {
    private static String JhoveConfigFile = "/config/jhove.conf";
    private static final String SaxClass = "org.apache.xerces.parsers.SAXParser";
    private static final String CanValidate = "edu.harvard.hul.ois.jhove.canValidate";
    private static JhoveBase JhoveBase = null;

    public static RepInfo getRepInfo(String fileName) {
        if (JhoveBase == null) {
            return null;
        }
        if (!new File(fileName).exists()) {
            return null;
        }
        File file = null;
        boolean isTemp = false;
        long lastModified = -1L;
        RepInfo info = new RepInfo(fileName);
        file = new File(fileName);
        if (!file.exists()) {
            info.setMessage((Message)new ErrorMessage("file not found"));
            info.setWellFormed(0);
        } else if (!file.isFile() || !file.canRead()) {
            info.setMessage((Message)new ErrorMessage("file cannot be read"));
            info.setWellFormed(0);
        } else {
            info.setSize(file.length());
            if (lastModified < 0L) {
                lastModified = file.lastModified();
            }
            info.setLastModified(new Date(lastModified));
            for (Module mod : JhoveBase.getModuleList()) {
                RepInfo infc = (RepInfo)info.clone();
                if (!mod.hasFeature(CanValidate)) continue;
                try {
                    if (!JhoveBase.processFile(null, mod, false, file, infc)) {
                        return null;
                    }
                    if (infc.getWellFormed() == 1) {
                        info.copy(infc);
                        break;
                    }
                    info.setSigMatch(infc.getSigMatch());
                }
                catch (Exception e) {}
            }
        }
        if (file != null && isTemp) {
            file.delete();
        }
        return info;
    }

    public static int getWellFormed(String fileName) {
        RepInfo result = MetadataProviderJHOVE.getRepInfo(fileName);
        return result == null ? null : Integer.valueOf(result.getWellFormed());
    }

    public static int getValid(String fileName) {
        RepInfo result = MetadataProviderJHOVE.getRepInfo(fileName);
        return result == null ? null : Integer.valueOf(result.getValid());
    }

    public static boolean isConsistent(String fileName) {
        RepInfo result = MetadataProviderJHOVE.getRepInfo(fileName);
        return result == null ? null : Boolean.valueOf(result.isConsistent());
    }

    public static String getMimeType(String fileName) {
        RepInfo result = MetadataProviderJHOVE.getRepInfo(fileName);
        return result == null ? null : result.getMimeType();
    }

    public static String getFormat(String fileName) {
        RepInfo result = MetadataProviderJHOVE.getRepInfo(fileName);
        return result == null ? null : result.getFormat();
    }

    public static String getVersion(String fileName) {
        RepInfo result = MetadataProviderJHOVE.getRepInfo(fileName);
        return result == null ? null : result.getVersion();
    }

    public static long getSize(String fileName) {
        RepInfo result = MetadataProviderJHOVE.getRepInfo(fileName);
        return result == null ? null : Long.valueOf(result.getSize());
    }

    public static Module getModule(String fileName) {
        RepInfo result = MetadataProviderJHOVE.getRepInfo(fileName);
        return result == null ? null : result.getModule();
    }

    public static List<String> getProfile(String fileName) {
        RepInfo result = MetadataProviderJHOVE.getRepInfo(fileName);
        return result == null ? null : result.getProfile();
    }

    static {
        Logger.getLogger().debug("Retrieving jhove...");
        String configFilePath = EnvironmentVariable.getAsFolder("DOCUTOOLS_HOME") + "/" + JhoveConfigFile;
        if (!new File(configFilePath).exists()) {
            File configFile = ResourceUtil.getResource(JhoveConfigFile);
            if (configFile != null) {
                try {
                    configFilePath = JhoveConfigFile = configFile.getCanonicalPath();
                }
                catch (IOException e) {
                    Logger.getLogger().error("error reading JhoveConfigFile: " + e);
                }
            } else {
                Logger.getLogger().error("cannot find JhoveConfigFile: " + JhoveConfigFile);
            }
        }
        try {
            JhoveBase = new JhoveBase();
            JhoveBase.setChecksumFlag(false);
            JhoveBase.init(configFilePath, SaxClass);
            if (JhoveBase.getAbort()) {
                JhoveBase = null;
            }
        }
        catch (Exception e) {
            Logger.getLogger().warn("Could not initialize JHOVE", (Throwable)e);
            JhoveBase = null;
        }
        Logger.getLogger().debug(JhoveBase == null ? "...NOK!" : "...done");
    }
}

