/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.gui;

import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingWorker;

public class SmallPeskyMessageWindow
extends JDialog
implements Observer {
    private JLabel label = new JLabel("", 0);
    private boolean isBlocking = false;

    public static void main(String[] args) {
        final JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        JButton b = new JButton();
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SwingWorker<Integer, Object>(){

                    @Override
                    public Integer doInBackground() {
                        try (SmallPeskyMessageWindow w = SmallPeskyMessageWindow.openBlocking(f, "Ready");){
                            Thread.sleep(1000L);
                            w.setText("Steady");
                            Thread.sleep(1000L);
                            w.setText("Go!");
                            Thread.sleep(1000L);
                        }
                        return 0;
                    }
                }.execute();
            }
        });
        f.add(b);
        f.setSize(400, 200);
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    private SmallPeskyMessageWindow(Window parent, String message, boolean isBlocking) {
        super(parent);
        this.isBlocking = isBlocking;
        if (this.isBlocking && parent != null) {
            parent.setEnabled(false);
        }
        this.setUndecorated(true);
        this.label.setText(message);
        this.add(this.label);
        this.setSize(300, 100);
        this.setLocationRelativeTo(parent);
    }

    public static SmallPeskyMessageWindow open(Window parent, String message) {
        SmallPeskyMessageWindow w = new SmallPeskyMessageWindow(parent, message, false);
        w.setCursor(Cursor.getPredefinedCursor(3));
        w.setVisible(true);
        return w;
    }

    public static SmallPeskyMessageWindow openBlocking(Window parent, String message) {
        SmallPeskyMessageWindow w = new SmallPeskyMessageWindow(parent, message, true);
        w.setCursor(Cursor.getPredefinedCursor(3));
        w.setVisible(true);
        return w;
    }

    public void setText(String message) {
        this.label.setText(message);
    }

    @Override
    public void update(Observable obs, Object obj) {
        this.setText(obj.toString());
    }

    public void close() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setVisible(false);
        this.dispose();
        if (this.isBlocking && this.getParent() != null) {
            this.getParent().setEnabled(true);
        }
    }
}

