/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.os;

import ch.docuteam.tools.file.ResourceUtil;
import ch.docuteam.tools.file.exception.FileIsNotADirectoryException;
import ch.docuteam.tools.os.OperatingSystem;
import ch.docuteam.tools.os.SystemProcessCantLaunchApplicationException;
import ch.docuteam.tools.os.SystemProcessException;
import ch.docuteam.tools.out.Logger;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;

public abstract class SystemProcess {
    public static final int OK = 0;

    public static void main(String[] args) throws Exception {
        SystemProcess.openExternally(ResourceUtil.getConfigFolder().getParent());
        SystemProcess.openExternally(ResourceUtil.getResourceCanonicalPath("/config/DROID_SignatureFile_V84.xml"));
        SystemProcess.openExternally("C:/Documents and Settings/user/Desktop/SIPs/DifferentFileTypes/Files/Freaky Wireless Technology.tiff");
        SystemProcess.openExternally("C:/Documents and Settings/user/Desktop/SIPs/DifferentFileTypes/Files/Handbuch_Arena.pdf");
        SystemProcess.openExternally("http://www.apple.com");
    }

    public static int execute(String ... args) throws FileNotFoundException, IOException, InterruptedException, FileIsNotADirectoryException {
        return SystemProcess.execute((File)null, args);
    }

    public static int execute(String workingDirectoryPath, String[] args) throws FileNotFoundException, IOException, InterruptedException, FileIsNotADirectoryException {
        return SystemProcess.execute(new File(workingDirectoryPath), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execute(File workingDirectory, String ... args) throws FileNotFoundException, IOException, InterruptedException, FileIsNotADirectoryException {
        int error = 0;
        if (args.length == 0) {
            throw new IndexOutOfBoundsException("No command to execute");
        }
        Logger.getLogger().debug("Executing command line: " + Arrays.toString(args));
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        processBuilder.redirectErrorStream(true);
        if (workingDirectory != null) {
            if (!workingDirectory.exists()) {
                throw new FileNotFoundException(workingDirectory.getPath());
            }
            if (!workingDirectory.isDirectory()) {
                throw new FileIsNotADirectoryException(workingDirectory);
            }
            processBuilder.directory(workingDirectory);
        }
        Logger.getLogger().debug("Working directory: " + processBuilder.directory());
        Process process = null;
        try {
            process = processBuilder.start();
            StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream());
            outputGobbler.start();
            error = process.waitFor();
            if (error == 5) {
                error = 0;
            }
            outputGobbler.join();
        }
        finally {
            try {
                if (process != null) {
                    process.getInputStream().close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (process != null) {
                    process.getOutputStream().close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (process != null) {
                    process.getErrorStream().close();
                }
            }
            catch (IOException iOException) {}
            if (process != null) {
                process.destroy();
            }
            process = null;
        }
        return error;
    }

    public static void openExternally(String fileOrURI) throws IOException, InterruptedException, SystemProcessException, FileIsNotADirectoryException, URISyntaxException, SystemProcessCantLaunchApplicationException {
        Logger.getLogger().debug("Opening externally: " + fileOrURI);
        if (Desktop.isDesktopSupported()) {
            if (fileOrURI.startsWith("http")) {
                URI uri = new URI(fileOrURI);
                Logger.getLogger().debug("Opening URI using Desktop: " + uri);
                Desktop.getDesktop().browse(uri);
            } else {
                File file = new File(fileOrURI);
                Logger.getLogger().debug("Opening file using Desktop: " + file);
                try {
                    Desktop.getDesktop().open(file.getCanonicalFile());
                }
                catch (IOException e) {
                    throw new SystemProcessCantLaunchApplicationException(fileOrURI);
                }
            }
        } else if (OperatingSystem.isWindows()) {
            Object[] cmd = new String[]{"cmd", "/c", "\"" + fileOrURI + "\""};
            Logger.getLogger().debug("Executing command line: " + Arrays.toString(cmd));
            int error = SystemProcess.execute((String[])cmd);
            Logger.getLogger().debug("Result: " + error);
            if (error != 0) {
                throw new SystemProcessException(error);
            }
        } else {
            Object[] cmd = new String[]{"open", fileOrURI};
            Logger.getLogger().debug("Executing command line: " + Arrays.toString(cmd));
            ProcessBuilder processBuilder = new ProcessBuilder((String[])cmd);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int error = process.waitFor();
            Logger.getLogger().debug("Result: " + error);
            if (error == 5) {
                error = 0;
            }
            if (error != 0) {
                throw new SystemProcessException(error);
            }
        }
    }

    public static class StreamGobbler
    extends Thread {
        InputStream is;

        StreamGobbler(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            Logger.getLogger().debug("Run");
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(this.is));
                String line = null;
                while ((line = br.readLine()) != null) {
                    Logger.getLogger().info(line);
                }
            }
            catch (IOException x) {
                Logger.getLogger().error(x.getMessage());
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }
}

