/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.out;

import ch.docuteam.tools.out.LogFile;
import ch.docuteam.tools.out.SystemOutRedirectionTarget;
import ch.docuteam.tools.out.SystemOutRedirectionTargetAbstract;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SystemOutRedirector
extends FilterOutputStream {
    private static PrintStream Out;
    private static PrintStream Err;
    private SystemOutRedirectionTarget target;

    public static void main(String[] args) {
        System.out.println("0.1");
        System.out.println("0.2");
        System.out.println("0.3");
        try {
            throw new RuntimeException("X0");
        }
        catch (RuntimeException x) {
            x.printStackTrace();
            new SystemOutRedirectionTargetExampleFile().install();
            System.out.println("1.1");
            System.out.println("1.2");
            System.out.println("1.3");
            try {
                throw new RuntimeException("X1");
            }
            catch (RuntimeException x2) {
                x2.printStackTrace();
                SystemOutRedirectionTargetExampleFile.uninstall();
                System.out.println("2.1");
                System.out.println("2.2");
                System.out.println("2.3");
                try {
                    throw new RuntimeException("X2");
                }
                catch (RuntimeException x3) {
                    x3.printStackTrace();
                    new SystemOutRedirectionTargetExampleTextArea().install();
                    System.out.println("3.1");
                    System.out.println("3.2");
                    System.out.println("3.3");
                    try {
                        throw new RuntimeException("X3");
                    }
                    catch (RuntimeException x4) {
                        x4.printStackTrace();
                        SystemOutRedirectionTargetExampleTextArea.uninstall();
                        System.out.println("4.1");
                        System.out.println("4.2");
                        System.out.println("4.3");
                        try {
                            throw new RuntimeException("X4");
                        }
                        catch (RuntimeException x5) {
                            x5.printStackTrace();
                            return;
                        }
                    }
                }
            }
        }
    }

    private SystemOutRedirector(SystemOutRedirectionTarget target) {
        super(new ByteArrayOutputStream());
        this.target = target;
        Out = System.out;
        Err = System.err;
        System.setOut(new PrintStream(this));
        System.setErr(new PrintStream(this));
    }

    public static void install(SystemOutRedirectionTarget target) {
        new SystemOutRedirector(target);
    }

    public static void unInstall() {
        System.setOut(Out);
        System.setErr(Err);
    }

    @Override
    public void write(byte[] b) {
        String str = new String(b);
        this.write(str);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        String str = new String(b, off, len);
        this.write(str);
    }

    @Override
    public void write(int b) {
        String str = new String(new char[]{(char)b});
        this.write(str);
    }

    private void write(String message) {
        this.target.write(message);
    }

    private static class SystemOutRedirectionTargetExampleTextArea
    extends SystemOutRedirectionTargetAbstract {
        private static JTextArea textArea = new JTextArea();

        private SystemOutRedirectionTargetExampleTextArea() {
        }

        @Override
        public void write(String string) {
            textArea.append(string);
        }

        static {
            JFrame f = new JFrame();
            f.setDefaultCloseOperation(3);
            f.add((Component)new JScrollPane(textArea), "Center");
            f.setSize(300, 200);
            f.setLocationRelativeTo(null);
            f.setVisible(true);
        }
    }

    private static class SystemOutRedirectionTargetExampleFile
    extends SystemOutRedirectionTargetAbstract {
        private SystemOutRedirectionTargetExampleFile() {
        }

        @Override
        public void write(String string) {
            try {
                LogFile.write((Object)string);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        static {
            LogFile.initializeAppend("temp/LogFile.txt");
        }
    }
}

