/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.out;

import ch.docuteam.tools.string.DateFormatter;

public abstract class Tracer {
    private static final String DateFormatString = "HH:mm:ss.SSS";
    private static final String Prefix = "";
    private static Boolean DoTrace = true;

    public static void switchOn() {
        DoTrace = true;
    }

    public static void switchOff() {
        DoTrace = false;
    }

    public static Boolean isOn() {
        return DoTrace;
    }

    public static void trace() {
        Tracer.doTrace(null);
    }

    public static void trace(Object o) {
        Tracer.doTrace(o);
    }

    public static void error() {
        Tracer.doError(null);
    }

    public static void error(Object o) {
        Tracer.doError(o);
    }

    private static void doTrace(Object o) {
        if (DoTrace.booleanValue()) {
            System.out.println(Tracer.constructMessage(o));
        }
    }

    private static void doError(Object o) {
        System.err.println(Tracer.constructMessage(o));
    }

    private static String constructMessage(Object o) {
        StackTraceElement caller = Thread.currentThread().getStackTrace()[4];
        String className = caller.getClassName();
        return Prefix + DateFormatter.getCurrentDateTimeString(DateFormatString) + ":" + className.substring(className.lastIndexOf(".") + 1) + "." + caller.getMethodName() + "()[" + caller.getLineNumber() + (o == null || o.equals(Prefix) ? "]" : "]:" + o);
    }
}

