/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.report;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xhtmlrenderer.pdf.ITextRenderer;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalConfig;
import uk.gov.nationalarchives.droid.report.ReportTransformException;
import uk.gov.nationalarchives.droid.report.ReportTransformer;

public class ReportTransformerImpl
implements ReportTransformer {
    private DroidGlobalConfig globalConfig;
    private Log log = LogFactory.getLog(this.getClass());

    @Override
    public void transformUsingXsl(Reader sourceReader, String xslScriptLocation, Writer out) throws TransformerException {
        InputStream transform = this.getClass().getClassLoader().getResourceAsStream(xslScriptLocation);
        this.transform(sourceReader, transform, out);
        if (transform != null) {
            try {
                transform.close();
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
        }
    }

    @Override
    public void transformUsingXsl(Reader sourceReader, File xslFile, Writer out) throws TransformerException {
        FileInputStream transform;
        try {
            transform = new FileInputStream(xslFile);
        }
        catch (FileNotFoundException e) {
            throw new TransformerException(e);
        }
        this.transform(sourceReader, transform, out);
    }

    private void transform(Reader sourceReader, InputStream xsl, Writer out) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StreamSource transformSource = new StreamSource(xsl);
        Transformer transformer = transformerFactory.newTransformer(transformSource);
        StreamSource source = new StreamSource(sourceReader);
        StreamResult result = new StreamResult(out);
        transformer.setParameter("reportDir", this.getReportDir());
        transformer.transform(source, result);
    }

    private String getReportDir() {
        String dir = "";
        if (this.globalConfig != null) {
            File reportDir = this.globalConfig.getReportDefinitionDir();
            dir = reportDir == null ? "" : reportDir.getAbsolutePath();
        }
        return dir;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void transformToPdf(Reader in, String transformLocation, OutputStream out) throws ReportTransformException {
        try {
            File tmpXhtml = File.createTempFile("xhtml~", null, this.globalConfig.getTempDir());
            tmpXhtml.deleteOnExit();
            try {
                FileWriter buffer = new FileWriter(tmpXhtml);
                this.transformUsingXsl(in, transformLocation, (Writer)buffer);
                buffer.close();
                ITextRenderer renderer = new ITextRenderer();
                renderer.setDocument(tmpXhtml);
                renderer.layout();
                renderer.createPDF(out);
                if (tmpXhtml.delete()) return;
                if (!tmpXhtml.exists()) return;
            }
            catch (TransformerException e) {
                try {
                    throw new ReportTransformException(e);
                    catch (DocumentException e2) {
                        throw new ReportTransformException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (tmpXhtml.delete()) throw throwable;
                    if (!tmpXhtml.exists()) throw throwable;
                    String message = String.format("Could not delete temporary XHTML report file:%s. Will try to delete on exit.", tmpXhtml.getAbsolutePath());
                    this.log.warn((Object)message);
                    tmpXhtml.deleteOnExit();
                    throw throwable;
                }
            }
            String message = String.format("Could not delete temporary XHTML report file:%s. Will try to delete on exit.", tmpXhtml.getAbsolutePath());
            this.log.warn((Object)message);
            tmpXhtml.deleteOnExit();
            return;
        }
        catch (IOException e) {
            throw new ReportTransformException(e);
        }
    }

    public void setConfig(DroidGlobalConfig config) {
        this.globalConfig = config;
    }
}

