/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.export;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalConfig;
import uk.gov.nationalarchives.droid.export.interfaces.ExportOptions;
import uk.gov.nationalarchives.droid.export.interfaces.ItemWriter;
import uk.gov.nationalarchives.droid.profile.NodeMetaData;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;

public class CsvItemWriter
implements ItemWriter<ProfileResourceNode> {
    private static final String FILE_URI_SCHEME = "file";
    private static final int HASH_ARRAY_INDEX = 12;
    private static final String[] HEADERS = new String[]{"ID", "PARENT_ID", "URI", "FILE_PATH", "NAME", "METHOD", "STATUS", "SIZE", "TYPE", "EXT", "LAST_MODIFIED", "EXTENSION_MISMATCH", "HASH", "FORMAT_COUNT", "PUID", "MIME_TYPE", "FORMAT_NAME", "FORMAT_VERSION"};
    private final Log log = LogFactory.getLog(this.getClass());
    private CSVWriter csvWriter;
    private DroidGlobalConfig config;
    private FastDateFormat dateFormat = DateFormatUtils.ISO_DATETIME_FORMAT;
    private ExportOptions options = ExportOptions.ONE_ROW_PER_FILE;
    private String[] headers;

    public void write(List<? extends ProfileResourceNode> nodes) {
        switch (this.options) {
            case ONE_ROW_PER_FILE: {
                this.writeOneRowPerFile(nodes);
                break;
            }
            case ONE_ROW_PER_FORMAT: {
                this.writeOneRowPerFormat(nodes);
                break;
            }
            default: {
                this.writeOneRowPerFile(nodes);
            }
        }
    }

    private void writeOneRowPerFile(List<? extends ProfileResourceNode> nodes) {
        try {
            for (ProfileResourceNode profileResourceNode : nodes) {
                NodeMetaData metaData = profileResourceNode.getMetaData();
                ArrayList<String> nodeEntries = new ArrayList<String>();
                nodeEntries.add(CsvItemWriter.nullSafeNumber(profileResourceNode.getId()));
                nodeEntries.add(CsvItemWriter.nullSafeNumber(profileResourceNode.getParentId()));
                nodeEntries.add(profileResourceNode.getUri().toString());
                nodeEntries.add(CsvItemWriter.toFilePath(profileResourceNode.getUri()));
                nodeEntries.add(CsvItemWriter.toFileName(metaData.getName()));
                nodeEntries.add(CsvItemWriter.nullSafeName(metaData.getIdentificationMethod()));
                nodeEntries.add(metaData.getNodeStatus().getStatus());
                nodeEntries.add(CsvItemWriter.nullSafeNumber(metaData.getSize()));
                nodeEntries.add(metaData.getResourceType().getResourceType());
                nodeEntries.add(metaData.getExtension());
                nodeEntries.add(CsvItemWriter.nullSafeDate(metaData.getLastModifiedDate(), this.dateFormat));
                nodeEntries.add(profileResourceNode.getExtensionMismatch().toString());
                nodeEntries.add(metaData.getHash());
                nodeEntries.add(CsvItemWriter.nullSafeNumber(profileResourceNode.getIdentificationCount()));
                for (Format format : profileResourceNode.getFormatIdentifications()) {
                    nodeEntries.add(format.getPuid());
                    nodeEntries.add(format.getMimeType());
                    nodeEntries.add(format.getName());
                    nodeEntries.add(format.getVersion());
                }
                this.csvWriter.writeNext(nodeEntries.toArray(new String[0]));
            }
            this.csvWriter.flush();
        }
        catch (IOException e) {
            this.log.error((Object)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void writeOneRowPerFormat(List<? extends ProfileResourceNode> nodes) {
        try {
            for (ProfileResourceNode profileResourceNode : nodes) {
                NodeMetaData metaData = profileResourceNode.getMetaData();
                for (Format format : profileResourceNode.getFormatIdentifications()) {
                    String[] nodeEntries = new String[]{CsvItemWriter.nullSafeNumber(profileResourceNode.getId()), CsvItemWriter.nullSafeNumber(profileResourceNode.getParentId()), profileResourceNode.getUri().toString(), CsvItemWriter.toFilePath(profileResourceNode.getUri()), CsvItemWriter.toFileName(metaData.getName()), CsvItemWriter.nullSafeName(metaData.getIdentificationMethod()), metaData.getNodeStatus().getStatus(), CsvItemWriter.nullSafeNumber(metaData.getSize()), metaData.getResourceType().getResourceType(), metaData.getExtension(), CsvItemWriter.nullSafeDate(metaData.getLastModifiedDate(), this.dateFormat), profileResourceNode.getExtensionMismatch().toString(), metaData.getHash(), CsvItemWriter.nullSafeNumber(profileResourceNode.getIdentificationCount()), format.getPuid(), format.getMimeType(), format.getName(), format.getVersion()};
                    this.csvWriter.writeNext(nodeEntries);
                }
            }
            this.csvWriter.flush();
        }
        catch (IOException e) {
            this.log.error((Object)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    void setCsvWriter(CSVWriter csvWriter) {
        this.csvWriter = csvWriter;
    }

    public void open(Writer writer) {
        this.csvWriter = new CSVWriter(writer);
        if (this.headers == null) {
            this.headers = HEADERS;
        }
        this.csvWriter.writeNext(this.headers);
    }

    public void setOptions(ExportOptions options) {
        this.options = options;
    }

    public void close() {
        try {
            this.csvWriter.close();
        }
        catch (IOException e) {
            this.log.error((Object)"Error closing CSV output file.", (Throwable)e);
        }
    }

    private static String nullSafeName(Enum<?> value) {
        return value == null ? "" : value.toString();
    }

    private static String nullSafeNumber(Number number) {
        return number == null ? "" : number.toString();
    }

    private static String nullSafeDate(Date date, FastDateFormat format) {
        return date == null ? "" : format.format(date);
    }

    private static String toFilePath(URI uri) {
        if (FILE_URI_SCHEME.equals(uri.getScheme())) {
            return new File(uri).getAbsolutePath();
        }
        return null;
    }

    private static String toFileName(String name) {
        return FilenameUtils.getName((String)name);
    }

    public void setConfig(DroidGlobalConfig config) {
        this.config = config;
    }

    public void setHeaders(Map<String, String> headersToSet) {
        String hashHeader;
        if (this.headers == null) {
            this.headers = HEADERS;
        }
        if ((hashHeader = headersToSet.get("hash")) != null) {
            this.headers[12] = hashHeader;
        }
    }
}

