/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.export.interfaces.ExportOptions;
import uk.gov.nationalarchives.droid.export.interfaces.ItemReader;
import uk.gov.nationalarchives.droid.export.interfaces.ItemReaderCallback;
import uk.gov.nationalarchives.droid.export.interfaces.ItemWriter;
import uk.gov.nationalarchives.droid.export.interfaces.JobCancellationException;
import uk.gov.nationalarchives.droid.profile.ProfileContextLocator;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileInstanceManager;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;

public class ExportTask
implements Runnable {
    private static final String PROJECT_NOT_AVAILABLE_FOR_EXPORT = "Profile not available for export: %s";
    private final Log log = LogFactory.getLog(this.getClass());
    private final String destination;
    private final List<String> profileIds;
    private final Filter filterOverride;
    private final ExportOptions options;
    private final String outputEncoding;
    private final ItemWriter<ProfileResourceNode> itemWriter;
    private final ProfileContextLocator profileContextLocator;
    private volatile boolean cancelled;

    public ExportTask(String destination, List<String> profileIds, Filter filterOverride, ExportOptions options, String outputEncoding, ItemWriter<ProfileResourceNode> itemWriter, ProfileContextLocator profileContextLocator) {
        this.destination = destination;
        this.profileIds = profileIds;
        this.filterOverride = filterOverride;
        this.options = options;
        this.outputEncoding = outputEncoding;
        this.itemWriter = itemWriter;
        this.profileContextLocator = profileContextLocator;
    }

    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public void run() {
        Writer writer;
        String destinationDescription;
        String string = destinationDescription = this.destination == null ? "System.out" : this.destination;
        if (this.destination == null) {
            writer = new PrintWriter(System.out);
        } else {
            try {
                writer = this.newOutputFileWriter();
            }
            catch (IOException e) {
                String message = String.format("IO exception occurred trying to read from: %s", destinationDescription);
                this.log.error((Object)message, (Throwable)e);
                throw new RuntimeException(message, e);
            }
        }
        this.doExport(writer, destinationDescription);
    }

    protected Writer newOutputFileWriter() throws IOException {
        BufferedWriter writer = this.outputEncoding != null ? new BufferedWriter(this.newOutputFileWriterEncoded(this.outputEncoding, new File(this.destination))) : new BufferedWriter(new FileWriter(this.destination));
        return writer;
    }

    protected Writer newOutputFileWriterEncoded(String encoding, File f) throws IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(f), encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExport(Writer writer, String destinationDescription) {
        File toDelete;
        this.log.info((Object)String.format("Exporting profiles to: [%s]", destinationDescription));
        Map<String, String> headerCustomisations = this.getHeaderCustomisationsFromProfiles();
        this.itemWriter.setHeaders(headerCustomisations);
        this.itemWriter.setOptions(this.options);
        this.itemWriter.open(writer);
        StopWatch stopWatch = new StopWatch();
        try {
            for (String profileId : this.profileIds) {
                stopWatch.start();
                if (!this.profileContextLocator.hasProfileContext(profileId)) {
                    String message = String.format(PROJECT_NOT_AVAILABLE_FOR_EXPORT, profileId);
                    this.log.warn((Object)message);
                    throw new RuntimeException(message);
                }
                ProfileInstance profile = this.profileContextLocator.getProfileInstance(profileId);
                ProfileInstanceManager profileContext = this.profileContextLocator.openProfileInstanceManager(profile);
                ItemReader reader = profileContext.getNodeItemReader();
                ItemReaderCallback<ProfileResourceNode> callback = new ItemReaderCallback<ProfileResourceNode>(){

                    public void onItem(List<? extends ProfileResourceNode> itemChunk) throws JobCancellationException {
                        ExportTask.this.itemWriter.write(itemChunk);
                        if (ExportTask.this.cancelled) {
                            ExportTask.this.log.info((Object)"Export interrupted");
                            throw new JobCancellationException("Cancelled");
                        }
                    }
                };
                Filter filter = this.filterOverride != null ? this.filterOverride : profile.getFilter();
                reader.readAll((ItemReaderCallback)callback, filter);
                stopWatch.stop();
                this.log.info((Object)String.format("Time for export [%s]: %s ms", profileId, stopWatch.getTime()));
                stopWatch.reset();
            }
        }
        catch (JobCancellationException e) {
            File toDelete2;
            try {
                String message = String.format("Export cancelled - deleting export destination: %s", destinationDescription);
                this.log.info((Object)message);
                this.cancelled = true;
            }
            catch (Throwable throwable) {
                File toDelete3;
                this.log.info((Object)String.format("Closing export file: %s", destinationDescription));
                this.itemWriter.close();
                if (this.cancelled && this.destination != null && !(toDelete3 = new File(this.destination)).delete() && toDelete3.exists()) {
                    this.log.warn((Object)String.format("Could not delete export file: %s. Will try to delete on exit.", this.destination));
                    toDelete3.deleteOnExit();
                }
                throw throwable;
            }
            this.log.info((Object)String.format("Closing export file: %s", destinationDescription));
            this.itemWriter.close();
            if (this.cancelled && this.destination != null && !(toDelete2 = new File(this.destination)).delete() && toDelete2.exists()) {
                this.log.warn((Object)String.format("Could not delete export file: %s. Will try to delete on exit.", this.destination));
                toDelete2.deleteOnExit();
            }
        }
        this.log.info((Object)String.format("Closing export file: %s", destinationDescription));
        this.itemWriter.close();
        if (this.cancelled && this.destination != null && !(toDelete = new File(this.destination)).delete() && toDelete.exists()) {
            this.log.warn((Object)String.format("Could not delete export file: %s. Will try to delete on exit.", this.destination));
            toDelete.deleteOnExit();
        }
    }

    private Map<String, String> getHeaderCustomisationsFromProfiles() {
        HashMap<String, String> map = new HashMap<String, String>();
        String hashAlgorithmHeader = "HASH";
        HashSet<String> algorithmsFound = new HashSet<String>();
        for (String profileId : this.profileIds) {
            if (!this.profileContextLocator.hasProfileContext(profileId)) {
                String message = String.format(PROJECT_NOT_AVAILABLE_FOR_EXPORT, profileId);
                this.log.warn((Object)message);
                throw new RuntimeException(message);
            }
            ProfileInstance profile = this.profileContextLocator.getProfileInstance(profileId);
            if (!profile.getGenerateHash().booleanValue()) continue;
            algorithmsFound.add(profile.getHashAlgorithm().toUpperCase());
        }
        if (algorithmsFound.size() == 1) {
            hashAlgorithmHeader = (String)algorithmsFound.iterator().next() + "_HASH";
        }
        map.put("hash", hashAlgorithmHeader);
        return map;
    }
}

