/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.report.interfaces;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import uk.gov.nationalarchives.droid.report.interfaces.Aggregator;
import uk.gov.nationalarchives.droid.report.interfaces.ProfileReportData;
import uk.gov.nationalarchives.droid.report.interfaces.ReportData;

public class GroupedFieldItem {
    @XmlElementWrapper(name="Values")
    @XmlElement(name="Value")
    private List<String> values = new ArrayList<String>();
    @XmlElementWrapper(name="ProfileSummaries")
    @XmlElement(name="ProfileSummary")
    private List<ProfileReportData> profileSummaries = new ArrayList<ProfileReportData>();
    @XmlElement(name="GroupAggregateSummary")
    private ReportData groupAggregateData = new ReportData();
    private Aggregator aggregator;

    public void setValues(List<String> values) {
        this.values.clear();
        this.values.addAll(values);
    }

    public void addProfileData(ProfileReportData profileData) {
        this.profileSummaries.add(profileData);
        this.groupAggregateData.addData(profileData);
        if (this.aggregator != null) {
            for (ReportData reportData : this.profileSummaries) {
                this.aggregator.aggregate(reportData);
            }
        }
    }

    public void addAggregator(Aggregator newAggregator) {
        this.aggregator = newAggregator;
        for (ReportData reportData : this.profileSummaries) {
            this.aggregator.aggregate(reportData);
        }
    }
}

