/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.planet.xml.dao;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import uk.gov.nationalarchives.droid.core.interfaces.NodeStatus;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceType;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterCriterion;
import uk.gov.nationalarchives.droid.core.interfaces.filter.RestrictionFactory;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Criterion;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Junction;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.QueryBuilder;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Restrictions;
import uk.gov.nationalarchives.droid.planet.xml.dao.GroupByPuidSizeAndCountRow;
import uk.gov.nationalarchives.droid.planet.xml.dao.GroupByYearSizeAndCountRow;
import uk.gov.nationalarchives.droid.planet.xml.dao.PlanetsXMLDao;
import uk.gov.nationalarchives.droid.planet.xml.dao.PlanetsXMLData;
import uk.gov.nationalarchives.droid.planet.xml.dao.ProfileStat;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;

public class JpaPlanetsXMLDaoImpl
implements PlanetsXMLDao {
    private static final int THREE = 3;
    private static final String ZERO = "0";
    private String filterQueryString = "";
    private Object[] filterParams;
    private boolean filterEnabled;
    private final Log log = LogFactory.getLog(this.getClass());
    @PersistenceContext
    private EntityManager entityManager;

    void flush() {
        this.entityManager.flush();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public PlanetsXMLData getDataForPlanetsXML(Filter filter) {
        this.filterQueryString = "";
        if (filter != null) {
            boolean bl = this.filterEnabled = filter.isEnabled() && !filter.getCriteria().isEmpty();
        }
        if (this.filterEnabled) {
            QueryBuilder queryBuilder = QueryBuilder.forAlias((String)"profileResourceNode");
            if (filter.isNarrowed()) {
                for (FilterCriterion criterion : filter.getCriteria()) {
                    queryBuilder.add(RestrictionFactory.forFilterCriterion((FilterCriterion)criterion));
                }
            } else {
                Junction orJunction = Restrictions.disjunction();
                for (FilterCriterion criterion : filter.getCriteria()) {
                    orJunction.add(RestrictionFactory.forFilterCriterion((FilterCriterion)criterion));
                }
                queryBuilder.add((Criterion)orJunction);
            }
            this.filterQueryString = " AND " + queryBuilder.toEjbQl();
            this.filterParams = queryBuilder.getValues();
        }
        PlanetsXMLData planetXMLData = new PlanetsXMLData();
        planetXMLData.setProfileStat(this.getProfileStat());
        planetXMLData.setGroupByPuid(this.getGroupByPuid());
        planetXMLData.setGroupByYear(this.getGroupByYear());
        return planetXMLData;
    }

    private void setFilterParameters(Query q, int startPosition) {
        if (this.filterEnabled) {
            int pos = startPosition;
            for (Object param : this.filterParams) {
                q.setParameter(pos++, param);
            }
        }
    }

    private ProfileStat getProfileStat() {
        ProfileStat profileStat = new ProfileStat();
        Query q = this.entityManager.createQuery("SELECT   min(profileResourceNode.metaData.size), max(profileResourceNode.metaData.size), avg(profileResourceNode.metaData.size), sum(profileResourceNode.metaData.size)  from  ProfileResourceNode profileResourceNode where profileResourceNode.metaData.resourceType != ?  " + this.filterQueryString);
        int paramIndex = 1;
        q.setParameter(paramIndex++, (Object)ResourceType.FOLDER);
        this.setFilterParameters(q, paramIndex);
        List results = q.getResultList();
        if (results != null && !results.isEmpty()) {
            for (Object res : results) {
                Object[] aaa = (Object[])res;
                BigInteger bigInt = aaa[0] == null ? new BigInteger(ZERO) : new BigInteger(aaa[0].toString());
                profileStat.setProfileSmallestSize(bigInt);
                bigInt = aaa[1] == null ? new BigInteger(ZERO) : new BigInteger(aaa[1].toString());
                profileStat.setProfileLargestSize(bigInt);
                BigDecimal bigDec = aaa[2] == null ? new BigDecimal(ZERO) : new BigDecimal(aaa[2].toString());
                profileStat.setProfileMeanSize(bigDec);
                bigInt = aaa[3] == null ? new BigInteger(ZERO) : new BigInteger(aaa[3].toString());
                profileStat.setProfileTotalSize(bigInt);
            }
        }
        this.setTotalUnreadableFiles(profileStat);
        this.setTotalUnreadableFolders(profileStat);
        this.setTotalReadableFiles(profileStat);
        return profileStat;
    }

    private void setTotalReadableFiles(ProfileStat profileStat) {
        Query queryForTotalReadableFiles = this.entityManager.createQuery("SELECT   count(*) from ProfileResourceNode profileResourceNode  where metaData.nodeStatus not in (?, ?) and (metaData.resourceType = 0 or metaData.resourceType != ?) " + this.filterQueryString);
        int index = 1;
        queryForTotalReadableFiles.setParameter(index++, (Object)NodeStatus.ACCESS_DENIED);
        queryForTotalReadableFiles.setParameter(index++, (Object)NodeStatus.NOT_FOUND);
        queryForTotalReadableFiles.setParameter(index++, (Object)ResourceType.FOLDER);
        this.setFilterParameters(queryForTotalReadableFiles, index);
        List results = queryForTotalReadableFiles.getResultList();
        if (results != null && !results.isEmpty()) {
            for (Object res : results) {
                profileStat.setProfileTotalReadableFiles(new BigInteger(res.toString()));
            }
        }
    }

    private void setTotalUnreadableFolders(ProfileStat profileStat) {
        Query queryForTotalUnreadableFolders = this.entityManager.createQuery("SELECT  count(*) from  ProfileResourceNode profileResourceNode where (metaData.nodeStatus = ? or metaData.nodeStatus = ?)  and metaData.resourceType = ? " + this.filterQueryString);
        int index = 1;
        queryForTotalUnreadableFolders.setParameter(index++, (Object)NodeStatus.ACCESS_DENIED);
        queryForTotalUnreadableFolders.setParameter(index++, (Object)NodeStatus.NOT_FOUND);
        queryForTotalUnreadableFolders.setParameter(index++, (Object)ResourceType.FOLDER);
        this.setFilterParameters(queryForTotalUnreadableFolders, index);
        List results = queryForTotalUnreadableFolders.getResultList();
        if (results != null && !results.isEmpty()) {
            for (Object res : results) {
                profileStat.setProfileTotalUnReadableFolders(new BigInteger(res.toString()));
            }
        }
    }

    private void setTotalUnreadableFiles(ProfileStat profileStat) {
        Query queryForTotalUnreadableFiles = this.entityManager.createQuery("SELECT count(*) from ProfileResourceNode profileResourceNode   where (metaData.nodeStatus = ? or metaData.nodeStatus = ?) and metaData.resourceType != ? " + this.filterQueryString);
        int index = 1;
        queryForTotalUnreadableFiles.setParameter(index++, (Object)NodeStatus.ACCESS_DENIED);
        queryForTotalUnreadableFiles.setParameter(index++, (Object)NodeStatus.NOT_FOUND);
        queryForTotalUnreadableFiles.setParameter(index++, (Object)ResourceType.FOLDER);
        this.setFilterParameters(queryForTotalUnreadableFiles, index);
        List results = queryForTotalUnreadableFiles.getResultList();
        if (results != null && !results.isEmpty()) {
            for (Object res : results) {
                profileStat.setProfileTotalUnReadableFiles(new BigInteger(res.toString()));
            }
        }
    }

    private List<GroupByYearSizeAndCountRow> getGroupByYear() {
        ArrayList<GroupByYearSizeAndCountRow> dataList = new ArrayList<GroupByYearSizeAndCountRow>();
        GroupByYearSizeAndCountRow groupByYearSizeAndCountRow = null;
        Query q = this.entityManager.createQuery("SELECT   year(profileResourceNode.metaData.lastModifiedDate), count(*), sum(profileResourceNode.metaData.size) from ProfileResourceNode  profileResourceNode where profileResourceNode.metaData.resourceType != ? " + this.filterQueryString + " group by year(profileResourceNode.metaData.lastModifiedDate) ");
        int index = 1;
        q.setParameter(index++, (Object)ResourceType.FOLDER);
        this.setFilterParameters(q, index);
        List results = q.getResultList();
        if (results != null && !results.isEmpty()) {
            for (Object res : results) {
                groupByYearSizeAndCountRow = new GroupByYearSizeAndCountRow();
                Object[] aaa = (Object[])res;
                if (aaa[0] != null) {
                    groupByYearSizeAndCountRow.setYear(new Integer(aaa[0].toString()));
                }
                if (aaa[1] != null) {
                    groupByYearSizeAndCountRow.setCount(new BigInteger(aaa[1].toString()));
                }
                if (aaa[2] != null) {
                    groupByYearSizeAndCountRow.setSize(new BigDecimal(aaa[2].toString()));
                }
                dataList.add(groupByYearSizeAndCountRow);
            }
        }
        return dataList;
    }

    private List<GroupByPuidSizeAndCountRow> getGroupByPuid() {
        ArrayList<GroupByPuidSizeAndCountRow> dataList = new ArrayList<GroupByPuidSizeAndCountRow>();
        GroupByPuidSizeAndCountRow groupByPuidSizeAndCountRow = null;
        Query q = this.entityManager.createQuery("SELECT  f.puid, count(*), sum(profileResourceNode.metaData.size) from ProfileResourceNode profileResourceNode inner join profileResourceNode.formatIdentifications f where  profileResourceNode.metaData.resourceType != ? " + this.filterQueryString + " group by f.puid ");
        int index = 1;
        q.setParameter(index++, (Object)ResourceType.FOLDER);
        this.setFilterParameters(q, index);
        List results = q.getResultList();
        if (results != null && !results.isEmpty()) {
            for (Object res : results) {
                groupByPuidSizeAndCountRow = new GroupByPuidSizeAndCountRow();
                Object[] aaa = (Object[])res;
                String puid = "";
                if (aaa[0] != null) {
                    puid = new String(aaa[0].toString());
                }
                groupByPuidSizeAndCountRow.setPuid(puid);
                if (aaa[1] != null) {
                    groupByPuidSizeAndCountRow.setCount(new BigInteger(aaa[1].toString()));
                }
                if (aaa[2] != null) {
                    groupByPuidSizeAndCountRow.setSize(new BigDecimal(aaa[2].toString()));
                }
                String query = "from Format  where puid =:puid";
                Query detailsQuery = this.entityManager.createQuery(query);
                detailsQuery.setParameter("puid", (Object)puid);
                Format format = (Format)detailsQuery.getSingleResult();
                groupByPuidSizeAndCountRow.setFormatName(format.getName());
                groupByPuidSizeAndCountRow.setFormatVersion(format.getVersion());
                groupByPuidSizeAndCountRow.setMimeType(format.getMimeType());
                dataList.add(groupByPuidSizeAndCountRow);
            }
        }
        return dataList;
    }
}

