/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileSpecDao;

public class JaxbProfileSpecDao
implements ProfileSpecDao {
    private static final String PROFILE_XML = "profile.xml";
    private final Log log = LogFactory.getLog(this.getClass());
    private final JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ProfileInstance.class});

    @Override
    public ProfileInstance loadProfile(InputStream in) {
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            ProfileInstance profile = (ProfileInstance)unmarshaller.unmarshal(in);
            return profile;
        }
        catch (JAXBException e) {
            this.log.error((Object)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveProfile(ProfileInstance profile, File profileHomeDir) {
        File profileXml = new File(profileHomeDir, PROFILE_XML);
        BufferedOutputStream out = null;
        try {
            Marshaller m = this.context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            out = new BufferedOutputStream(new FileOutputStream(profileXml));
            m.marshal((Object)profile, (OutputStream)out);
            this.closeOutputStream(out);
            return;
        }
        catch (PropertyException e) {
            try {
                this.log.error((Object)e);
                throw new RuntimeException(e);
                catch (FileNotFoundException e2) {
                    this.log.error((Object)e2);
                    throw new RuntimeException(e2);
                }
                catch (JAXBException e3) {
                    this.log.error((Object)e3);
                    throw new RuntimeException(e3);
                }
            }
            catch (Throwable throwable) {
                this.closeOutputStream(out);
                throw throwable;
            }
        }
    }

    private void closeOutputStream(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                this.log.error((Object)("Error closing output stream: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

