/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.QueryBuilder;
import uk.gov.nationalarchives.droid.profile.ProfileDao;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.SqlUtils;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;

public class JpaProfileDaoImpl
implements ProfileDao {
    private final Log log = LogFactory.getLog(this.getClass());
    @PersistenceContext
    private EntityManager entityManager;

    void flush() {
        this.entityManager.flush();
    }

    @Override
    public List<Format> getAllFormats() {
        String query = "from Format order by name";
        Query q = this.entityManager.createQuery(query);
        return q.getResultList();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void saveFormat(Format format) {
        this.entityManager.persist((Object)format);
    }

    @Override
    public List<ProfileResourceNode> findProfileResourceNodes(Long parentId) {
        String query = "select * from profile_resource_node n where n.parent_id " + this.getParentIdQuery(parentId);
        Query q = this.entityManager.createNativeQuery(query, ProfileResourceNode.class);
        if (parentId != null) {
            q.setParameter(1, (Object)parentId);
        }
        List results = q.getResultList();
        return results;
    }

    @Override
    public List<ProfileResourceNode> findProfileResourceNodes(Long parentId, Filter filter) {
        Object value;
        int j;
        QueryBuilder queryBuilder = SqlUtils.getQueryBuilder(filter);
        String ejbFilter = queryBuilder.toEjbQl();
        String query = this.getSQLQueryString(ejbFilter, parentId);
        Query q = this.entityManager.createNativeQuery(query, "ResourceNodeWithFilterStatus");
        int i = 1;
        Object[] values = queryBuilder.getValues();
        for (j = 0; j < values.length; ++j) {
            value = values[j];
            value = SqlUtils.transformParameterToSQLValue(value);
            q.setParameter(i++, value);
        }
        for (j = 0; j < values.length; ++j) {
            value = values[j];
            value = SqlUtils.transformParameterToSQLValue(value);
            q.setParameter(i++, value);
        }
        if (parentId != null) {
            q.setParameter(i++, (Object)parentId);
        }
        long start = System.currentTimeMillis();
        List queryResults = q.getResultList();
        this.log.debug((Object)("Query time (ms) = " + (System.currentTimeMillis() - start)));
        ArrayList<ProfileResourceNode> result = new ArrayList<ProfileResourceNode>();
        for (Object[] objects : queryResults) {
            Integer status = (Integer)objects[1];
            if (status <= 0) continue;
            ProfileResourceNode node = (ProfileResourceNode)objects[0];
            node.setFilterStatus(status);
            result.add(node);
        }
        return result;
    }

    private String getSQLQueryString(String ejbFilter, Long parentId) {
        boolean formatCriteriaExist = this.formatCriteriaExist(ejbFilter);
        boolean formatMetadataExist = formatCriteriaExist ? this.formatMetadataExist(ejbFilter) : false;
        String filterCriteriaDirect = SqlUtils.transformEJBtoSQLFields(ejbFilter, "profile", "form");
        String filterCriteriaChild = SqlUtils.transformEJBtoSQLFields(ejbFilter, "children", "child_form");
        String query = formatCriteriaExist ? "select distinct profile.*," : "select profile.*,";
        query = query + " case when (" + filterCriteriaDirect + ") then 1" + " else case when profile.resource_type <> 2 and exists (" + " select children.node_id from profile_resource_node as children";
        if (formatCriteriaExist) {
            query = formatMetadataExist ? query + " inner join identification as child_ident on child_ident.node_id = children.node_id" + " inner join format as child_form on child_form.puid = child_ident.puid" : query + " inner join identification as child_form on child_form.node_id = children.node_id";
        }
        query = query + " where children.prefix > profile.prefix and children.prefix < profile.prefix_plus_one" + " and (" + filterCriteriaChild + ")) then 2 else 0 end end as FilterStatus" + " from profile_resource_node as profile";
        if (formatCriteriaExist) {
            query = formatMetadataExist ? query + " inner join identification as ident on ident.node_id = profile.node_id" + " inner join format as form on form.puid = ident.puid" : query + " inner join identification as form on form.node_id = profile.node_id";
        }
        return query + " where profile.parent_id " + this.getParentIdQuery(parentId);
    }

    private boolean formatCriteriaExist(String filter) {
        return filter.contains("format.");
    }

    private boolean formatMetadataExist(String filter) {
        return filter.contains("format.mimeType") || filter.contains("format.name");
    }

    private String getParentIdQuery(Long parentId) {
        return parentId == null ? "is null" : " = ?";
    }
}

