/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityResult;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import uk.gov.nationalarchives.droid.core.interfaces.TextEncoding;
import uk.gov.nationalarchives.droid.profile.NodeMetaData;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;
import uk.gov.nationalarchives.droid.profile.types.UriType;

@TypeDef(name="uri", typeClass=UriType.class)
@Entity
@Table(name="profile_resource_node")
@SqlResultSetMappings(value={@SqlResultSetMapping(name="ResourceNodeWithFilterStatus", entities={@EntityResult(entityClass=ProfileResourceNode.class)}, columns={@ColumnResult(name="FilterStatus")})})
@GenericGenerator(name="hilo-custom-strategy", strategy="hilo")
public class ProfileResourceNode {
    private static final int URI_LENGTH = 4000;
    @Id
    @GeneratedValue(generator="hilo-custom-strategy")
    @Column(name="node_id")
    private Long id;
    @Column(name="parent_id", unique=false)
    @Index(name="idx_parent_id")
    private Long parentId;
    @Column(nullable=false, name="uri", unique=false, length=4000)
    @Type(type="uri")
    @Index(name="idx_uri")
    private URI uri;
    @Column(name="prefix")
    @Index(name="idx_prefix")
    private String prefix;
    @Index(name="idx_prefix_plus_one")
    @Column(name="prefix_plus_one")
    private String prefixPlusOne;
    @Index(name="idx_id_count")
    @Column(name="identification_count")
    private Integer identificationCount;
    @Column(name="finished_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date finished;
    @Index(name="idx_extension_mismatch")
    @Column(nullable=false, name="extension_mismatch")
    private Boolean extensionMismatch = false;
    @Index(name="idx_text_encoding")
    @Column(name="text_encoding")
    @Enumerated(value=EnumType.ORDINAL)
    private TextEncoding textEncoding;
    @Fetch(value=FetchMode.SELECT)
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="identification", joinColumns={@JoinColumn(name="node_id")}, inverseJoinColumns={@JoinColumn(name="puid")})
    private List<Format> formatIdentifications = new ArrayList<Format>();
    @Transient
    private Integer filterStatus = 1;
    @Embedded
    private NodeMetaData metaData = new NodeMetaData();

    ProfileResourceNode() {
    }

    public ProfileResourceNode(URI uri) {
        this.uri = uri;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean allowsChildren() {
        return this.metaData.getResourceType().allowsChildren();
    }

    public NodeMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(NodeMetaData metaData) {
        this.metaData = metaData;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.uri).toHashCode();
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProfileResourceNode other = (ProfileResourceNode)obj;
        return new EqualsBuilder().append((Object)this.uri, (Object)other.uri).isEquals();
    }

    public String toString() {
        return URLDecoder.decode(this.uri.toString());
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefixPlusOne() {
        return this.prefixPlusOne;
    }

    public void setPrefixPlusOne(String prefixPlusOne) {
        this.prefixPlusOne = prefixPlusOne;
    }

    public void addFormatIdentification(Format formatIdentification) {
        this.formatIdentifications.add(formatIdentification);
        if (!formatIdentification.equals(Format.NULL)) {
            if (this.identificationCount == null) {
                this.setZeroIdentifications();
            }
            Integer n = this.identificationCount;
            Integer n2 = this.identificationCount = Integer.valueOf(this.identificationCount + 1);
        }
    }

    public void setZeroIdentifications() {
        this.identificationCount = 0;
    }

    public List<Format> getFormatIdentifications() {
        return Collections.unmodifiableList(this.formatIdentifications);
    }

    public Integer getIdentificationCount() {
        return this.identificationCount;
    }

    public void setFilterStatus(Integer status) {
        this.filterStatus = status;
    }

    public int getFilterStatus() {
        return this.filterStatus;
    }

    public void setNoFormatsIdentified() {
        this.identificationCount = null;
    }

    public Boolean getExtensionMismatch() {
        return this.extensionMismatch;
    }

    public void setExtensionMismatch(Boolean extensionMismatch) {
        this.extensionMismatch = extensionMismatch;
    }

    public void setFinished(Date date) {
        this.finished = date;
    }
}

