/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile.export;

import java.util.ArrayList;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.export.interfaces.ItemReader;
import uk.gov.nationalarchives.droid.export.interfaces.ItemReaderCallback;
import uk.gov.nationalarchives.droid.export.interfaces.JobCancellationException;
import uk.gov.nationalarchives.droid.profile.export.HqlFilterParser;

public class HibernateItemReader<T>
implements ItemReader<T> {
    private SessionFactory sessionFactory;
    private Session session;
    private ScrollableResults cursor;
    private int fetchSize;
    private int chunkSize;

    public T read() {
        if (this.cursor.next()) {
            Object[] data = this.cursor.get();
            Object item = data[0];
            return (T)item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAll(ItemReaderCallback<T> callback, Filter filter) throws JobCancellationException {
        this.open(filter);
        try {
            T item;
            ArrayList<T> chunk = new ArrayList<T>();
            while ((item = this.read()) != null) {
                chunk.add(item);
                if (chunk.size() != this.chunkSize) continue;
                callback.onItem(chunk);
                chunk = new ArrayList();
                this.session.clear();
            }
            if (!chunk.isEmpty()) {
                callback.onItem(chunk);
                chunk = new ArrayList();
                this.session.clear();
            }
        }
        finally {
            this.close();
        }
    }

    public void open(Filter filter) {
        this.cursor = this.getForwardOnlyCursor(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            finally {
                this.session = null;
            }
        }
    }

    private ScrollableResults getForwardOnlyCursor(Filter filter) {
        Query query;
        if (this.session == null) {
            this.session = this.sessionFactory.openSession();
            this.session.setFlushMode(FlushMode.MANUAL);
        }
        String queryString = " from ProfileResourceNode profileResourceNode ";
        if (filter != null && filter.isEnabled()) {
            HqlFilterParser filterParser = new HqlFilterParser();
            query = filterParser.parse(filter, this.session, queryString);
        } else {
            query = this.session.createQuery(queryString);
        }
        return query.setFetchSize(this.fetchSize).scroll(ScrollMode.FORWARD_ONLY);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }
}

