/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.report.dao;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import uk.gov.nationalarchives.droid.report.dao.GroupByField;
import uk.gov.nationalarchives.droid.report.dao.ReportFieldType;
import uk.gov.nationalarchives.droid.report.dao.ReportLineItem;

public class NumericFieldType
implements ReportFieldType {
    private static final int COUNT_INDEX = 0;
    private static final int SUM_INDEX = 1;
    private static final int AVG_INDEX = 2;
    private static final int MIN_INDEX = 3;
    private static final int MAX_INDEX = 4;
    private static final int GROUP_INDEX = 5;
    private String field;
    private boolean isGroupByExists;
    private List<GroupByField> groupingFields;

    public NumericFieldType(String field) {
        this.field = field;
    }

    @Override
    public String getSelectFieldString(List<GroupByField> groupByFields) {
        StringBuilder selectFieldQueryString = new StringBuilder();
        selectFieldQueryString.append("count(" + this.field + "), sum(" + this.field + "), avg(" + this.field + "), min(" + this.field + "), max(" + this.field + ") ");
        this.groupingFields = groupByFields;
        boolean bl = this.isGroupByExists = groupByFields != null && groupByFields.size() > 0;
        if (this.isGroupByExists) {
            for (GroupByField group : this.groupingFields) {
                selectFieldQueryString.append(" , ");
                String function = group.getFunction();
                if (function != null && !function.isEmpty()) {
                    selectFieldQueryString.append(function + "(");
                }
                String groupByFieldName = group.getGroupByField().getType().getField();
                selectFieldQueryString.append(groupByFieldName);
                if (function == null || function.isEmpty()) continue;
                selectFieldQueryString.append(")");
            }
        }
        return selectFieldQueryString.toString();
    }

    @Override
    public List<ReportLineItem> populateReportedData(List<?> results) {
        ArrayList<ReportLineItem> reportData = new ArrayList<ReportLineItem>();
        ReportLineItem reportLineItem = null;
        for (Object res : results) {
            reportLineItem = new ReportLineItem();
            Object[] resultsArray = (Object[])res;
            Object count = resultsArray[0];
            Object sum = resultsArray[1];
            Object average = resultsArray[2];
            Object minimum = resultsArray[3];
            Object maximum = resultsArray[4];
            if (count != null) {
                reportLineItem.setCount(new Long(((Integer)count).intValue()));
            }
            if (sum != null) {
                reportLineItem.setSum(((BigInteger)sum).longValue());
            }
            if (average != null) {
                reportLineItem.setAverage(((BigInteger)average).doubleValue());
            }
            if (minimum != null) {
                reportLineItem.setMinimum(((BigInteger)minimum).longValue());
            }
            if (maximum != null) {
                reportLineItem.setMaximum(((BigInteger)maximum).longValue());
            }
            if (this.isGroupByExists) {
                ArrayList<String> values = new ArrayList<String>();
                for (int valueIndex = 0; valueIndex < this.groupingFields.size(); ++valueIndex) {
                    values.add(this.getFieldValue(resultsArray[5 + valueIndex]));
                }
                reportLineItem.setGroupByValues(values);
            }
            reportData.add(reportLineItem);
        }
        return reportData;
    }

    private String getFieldValue(Object value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public String getField() {
        return this.field;
    }
}

