/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.report.dao;

import java.util.HashMap;
import java.util.Map;
import uk.gov.nationalarchives.droid.report.dao.DateFieldType;
import uk.gov.nationalarchives.droid.report.dao.NumericFieldType;
import uk.gov.nationalarchives.droid.report.dao.ReportFieldType;
import uk.gov.nationalarchives.droid.report.dao.StringOrSetFieldType;

public enum ReportFieldEnum {
    FILE_NAME("File name", new StringOrSetFieldType("profile.name")),
    FILE_SIZE("File size", new NumericFieldType("profile.file_size")),
    LAST_MODIFIED_DATE("Last modified date", new DateFieldType("profile.last_modified_date")),
    RESOURCE_TYPE("Resource type", new StringOrSetFieldType("profile.resource_type")),
    IDENTIFICATION_METHOD("Identification method", new StringOrSetFieldType("profile.identification_method")),
    IDENTIFICATION_STATUS("Identification status", new StringOrSetFieldType("profile.node_status")),
    FILE_EXTENSION("File extension", new StringOrSetFieldType("profile.extension")),
    PUID("PUID", new StringOrSetFieldType("format.puid")),
    MIME_TYPE("Mime type", new StringOrSetFieldType("format.mime_type")),
    FILE_FORMAT("Format name", new StringOrSetFieldType("format.name")),
    FORMAT_VERSION("Format version", new StringOrSetFieldType("format.version"));

    private static Map<String, ReportFieldEnum> allFields;
    private String name;
    private ReportFieldType type;

    private ReportFieldEnum(String name, ReportFieldType type) {
        this.name = name;
        this.type = type;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public ReportFieldType getType() {
        return this.type;
    }

    static {
        allFields = new HashMap<String, ReportFieldEnum>();
        for (ReportFieldEnum value : ReportFieldEnum.values()) {
            allFields.put(value.toString(), value);
        }
    }
}

