/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.report.dao;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Criterion;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.QueryBuilder;
import uk.gov.nationalarchives.droid.profile.SqlUtils;
import uk.gov.nationalarchives.droid.report.dao.GroupByField;
import uk.gov.nationalarchives.droid.report.dao.ReportDao;
import uk.gov.nationalarchives.droid.report.dao.ReportFieldEnum;
import uk.gov.nationalarchives.droid.report.dao.ReportFieldType;
import uk.gov.nationalarchives.droid.report.dao.ReportLineItem;

public class SqlReportDaoImpl
implements ReportDao {
    private static String formatfilter = "formatfilter";
    private final Log log = LogFactory.getLog(this.getClass());
    @PersistenceContext
    private EntityManager entityManager;

    void flush() {
        this.entityManager.flush();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<ReportLineItem> getReportData(Criterion filter, ReportFieldEnum reportField) {
        return this.getReportData(filter, reportField, new ArrayList<GroupByField>());
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<ReportLineItem> getReportData(Criterion filter, ReportFieldEnum reportField, List<GroupByField> groupByFields) {
        Query query = this.getQuery(reportField, groupByFields, filter);
        List results = query.getResultList();
        List<ReportLineItem> reportData = new ArrayList<ReportLineItem>();
        if (results != null && !results.isEmpty()) {
            reportData = reportField.getType().populateReportedData(results);
        }
        return reportData;
    }

    private Query getQuery(ReportFieldEnum reportField, List<GroupByField> groupByFields, Criterion filter) {
        String selectStatement = this.getSelectStatement(reportField, groupByFields);
        FilterInfo filterInfo = this.getFilterInfo(filter);
        String groupingStatement = this.getGroupingStatement(groupByFields);
        String queryString = selectStatement + filterInfo.getFilterSubQuery() + groupingStatement;
        Query query = this.entityManager.createNativeQuery(queryString);
        this.setFilterParameters(query, filterInfo.getFilterValues());
        return query;
    }

    private String getSelectStatement(ReportFieldEnum reportField, List<GroupByField> groupByFields) {
        ReportFieldType selectType = reportField.getType();
        return "SELECT " + selectType.getSelectFieldString(groupByFields) + " FROM profile_resource_node AS profile ";
    }

    private FilterInfo getFilterInfo(Criterion filter) {
        FilterInfo filterInfo = new FilterInfo();
        QueryBuilder queryBuilder = QueryBuilder.forAlias((String)"profileResourceNode").createAlias("format");
        queryBuilder.add(filter);
        String ejbQl = queryBuilder.toEjbQl();
        if (ejbQl.length() > 0) {
            filterInfo.setFilterSubQuery(this.buildFilterSubQuery(ejbQl));
            filterInfo.setFilterValues(queryBuilder.getValues());
        }
        return filterInfo;
    }

    private String getGroupingStatement(List<GroupByField> groupByFields) {
        StringBuilder groupByFieldQuery = new StringBuilder();
        if (groupByFields != null && groupByFields.size() > 0) {
            boolean puidGroup = false;
            boolean formatMetadataGroup = false;
            for (GroupByField group : groupByFields) {
                ReportFieldEnum groupField = group.getGroupByField();
                puidGroup |= this.groupOnPUID(groupField);
                formatMetadataGroup |= this.groupOnFormatMetadata(groupField);
            }
            if (formatMetadataGroup) {
                groupByFieldQuery.append(" INNER JOIN identification as ident on ident.node_id = profile.node_id  INNER JOIN format as format on format.puid = ident.puid ");
            } else if (puidGroup) {
                groupByFieldQuery.append(" INNER JOIN identification as format on format.node_id = profile.node_id ");
            }
            groupByFieldQuery.append(this.getGroupByClause(groupByFields));
        }
        return groupByFieldQuery.toString();
    }

    private String getGroupByClause(List<GroupByField> groupByFields) {
        StringBuilder groupByFieldQuery = new StringBuilder();
        groupByFieldQuery.append("GROUP BY ");
        String separator = "";
        for (GroupByField group : groupByFields) {
            String groupFieldName = group.getGroupByField().getType().getField();
            String groupFunction = group.getFunction();
            groupByFieldQuery.append(separator);
            if (groupFunction != null && !groupFunction.isEmpty()) {
                groupByFieldQuery.append(groupFunction + "(");
            }
            groupByFieldQuery.append(groupFieldName);
            if (groupFunction != null && !groupFunction.isEmpty()) {
                groupByFieldQuery.append(") ");
            }
            separator = ", ";
        }
        return groupByFieldQuery.toString();
    }

    private String buildFilterSubQuery(String ejbQl) {
        String filterSQL = SqlUtils.transformEJBtoSQLFields(ejbQl, "filter", formatfilter);
        String subQuery = " INNER JOIN (SELECT DISTINCT filter.node_id  FROM profile_resource_node AS filter ";
        if (this.filterOnFormats(filterSQL)) {
            subQuery = this.filterOnFormatMetadata(filterSQL) ? subQuery + " INNER JOIN identification as formatident ON formatident.node_id = filter.node_id  INNER JOIN format as formatfilter ON formatfilter.puid = formatident.puid " : subQuery + " INNER JOIN identification as formatfilter ON formatfilter.node_id = filter.node_id ";
        }
        subQuery = subQuery + " WHERE " + filterSQL + ") AS filtered " + " ON filtered.node_id = profile.node_id ";
        return subQuery;
    }

    private boolean filterOnFormats(String queryString) {
        return queryString.contains(formatfilter);
    }

    private boolean filterOnFormatMetadata(String queryString) {
        return queryString.contains("formatfilter.name") || queryString.contains("formatfilter.mime_type");
    }

    private boolean groupOnPUID(ReportFieldEnum groupByField) {
        return groupByField.equals((Object)ReportFieldEnum.PUID);
    }

    private boolean groupOnFormatMetadata(ReportFieldEnum groupByField) {
        return groupByField.equals((Object)ReportFieldEnum.FILE_FORMAT) || groupByField.equals((Object)ReportFieldEnum.MIME_TYPE);
    }

    private void setFilterParameters(Query q, Object[] filterParams) {
        int pos = 1;
        for (Object param : filterParams) {
            Object transformedValue = SqlUtils.transformParameterToSQLValue(param);
            q.setParameter(pos++, transformedValue);
        }
    }

    private class FilterInfo {
        private String filterSubQuery = "";
        private Object[] filterValues = new Object[0];

        private FilterInfo() {
        }

        public String getFilterSubQuery() {
            return this.filterSubQuery;
        }

        public Object[] getFilterValues() {
            return this.filterValues;
        }

        public void setFilterSubQuery(String subQuery) {
            this.filterSubQuery = subQuery;
        }

        public void setFilterValues(Object[] values) {
            this.filterValues = values;
        }
    }
}

