/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.results.handlers;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ResourceUtils;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;
import uk.gov.nationalarchives.droid.results.handlers.ResultHandlerDao;

public class JpaResultHandlerDao
implements ResultHandlerDao {
    private final Log log = LogFactory.getLog(this.getClass());
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public void save(ProfileResourceNode node, ResourceId parentId) {
        this.entityManager.persist((Object)node);
        Long nodeId = node.getId();
        String nodePrefix = ResourceUtils.getBase128Integer((long)nodeId);
        String nodePrefixPlusOne = ResourceUtils.getBase128Integer((long)(nodeId + 1L));
        String parentsPrefixString = "";
        if (parentId != null) {
            parentsPrefixString = parentId.getPath();
            node.setParentId(parentId.getId());
        }
        node.setPrefix(parentsPrefixString + nodePrefix);
        node.setPrefixPlusOne(parentsPrefixString + nodePrefixPlusOne);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Format loadFormat(String puid) {
        return (Format)this.entityManager.find(Format.class, (Object)puid);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ProfileResourceNode loadNode(Long nodeId) {
        return (ProfileResourceNode)this.entityManager.find(ProfileResourceNode.class, (Object)nodeId);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteNode(Long nodeId) {
        ProfileResourceNode node = (ProfileResourceNode)this.entityManager.getReference(ProfileResourceNode.class, (Object)nodeId);
        this.log.debug((Object)String.format("Deleting Node [%s]", node.getUri()));
        String nodesToRemove = "from ProfileResourceNode n  where n.prefix >= ?  and n.prefix < ? ";
        Query q = this.entityManager.createQuery(nodesToRemove);
        q.setParameter(1, (Object)node.getPrefix());
        q.setParameter(2, (Object)node.getPrefixPlusOne());
        for (Object o : q.getResultList()) {
            this.entityManager.remove(o);
        }
    }
}

