/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.submitter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.AsynchDroid;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationErrorType;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationException;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.profile.throttle.SubmissionThrottle;

public class FileEventHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private AsynchDroid droidCore;
    private ResultHandler resultHandler;
    private IdentificationRequestFactory requestFactory;
    private SubmissionThrottle submissionThrottle;

    public FileEventHandler() {
    }

    public FileEventHandler(AsynchDroid droidCore) {
        this.droidCore = droidCore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(File file, ResourceId parentId, ResourceId nodeId) {
        URI uri = file.toURI();
        RequestMetaData metaData = new RequestMetaData(Long.valueOf(file.length()), Long.valueOf(file.lastModified()), file.getName());
        RequestIdentifier identifier = new RequestIdentifier(uri);
        identifier.setParentResourceId(parentId);
        identifier.setResourceId(nodeId);
        IdentificationRequest request = this.requestFactory.newRequest(metaData, identifier);
        try {
            FileInputStream in = new FileInputStream(file);
            try {
                request.open((InputStream)in);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            this.droidCore.submit(request);
            this.submissionThrottle.apply();
        }
        catch (IOException e) {
            IdentificationErrorType error;
            IdentificationErrorType identificationErrorType = error = file.exists() ? IdentificationErrorType.ACCESS_DENIED : IdentificationErrorType.FILE_NOT_FOUND;
            if (error.equals((Object)IdentificationErrorType.ACCESS_DENIED)) {
                this.log.warn((Object)String.format("Access was denied to the file: [%s]", file.getAbsolutePath()));
            } else {
                this.log.warn((Object)String.format("File not found: [%s]", file.getAbsolutePath()));
            }
            this.resultHandler.handleError(new IdentificationException(request, error, (Throwable)e));
        }
        catch (InterruptedException e) {
            this.log.debug((Object)"Interrupted while throttle active.", (Throwable)e);
        }
    }

    public SubmissionThrottle getSubmissionThrottle() {
        return this.submissionThrottle;
    }

    public void setSubmissionThrottle(SubmissionThrottle submissionThrottle) {
        this.submissionThrottle = submissionThrottle;
    }

    public void setDroidCore(AsynchDroid droidCore) {
        this.droidCore = droidCore;
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public void setRequestFactory(IdentificationRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }
}

