/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.filePreview;

import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.packer.gui.filePreview.FilePreviewPanel;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.os.SystemProcess;
import ch.docuteam.tools.os.SystemProcessCantLaunchApplicationException;
import ch.docuteam.tools.translations.I18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class FilePreviewer
extends JPanel {
    private JFrame filePreviewFrame;
    private JPanel filePreviewPanelContainer;
    private JButton openFileExternallyButton = new JButton(I18N.translate((String)"ButtonOpenFileExternally"), PackerConstants.getImageIcon("View.png"));
    private JButton openFileSeparatelyButton;
    private NodeAbstract node;

    public FilePreviewer() {
        super(new BorderLayout());
        this.openFileExternallyButton.setEnabled(false);
        this.openFileExternallyButton.setToolTipText(I18N.translate((String)"ToolTipOpenFileExternally"));
        this.openFileExternallyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilePreviewer.this.openFileExternallyButtonClicked(FilePreviewer.this.node);
            }
        });
        this.openFileSeparatelyButton = new JButton(I18N.translate((String)"ButtonOpenFileSeparately"), PackerConstants.getImageIcon("PreviewInWindow.png"));
        this.openFileSeparatelyButton.setEnabled(false);
        this.openFileSeparatelyButton.setToolTipText(I18N.translate((String)"ToolTipOpenFileSeparately"));
        this.openFileSeparatelyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilePreviewer.this.openFileSeparatelyButtonClicked(FilePreviewer.this.node);
            }
        });
        this.filePreviewPanelContainer = new JPanel(new BorderLayout());
        this.filePreviewPanelContainer.add(new JPanel());
        Box buttonBox = new Box(0);
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(this.openFileExternallyButton);
        buttonBox.add(this.openFileSeparatelyButton);
        buttonBox.add(Box.createHorizontalGlue());
        this.add((Component)buttonBox, "North");
        this.add((Component)this.filePreviewPanelContainer, "Center");
    }

    public static void setCacheSizeLimit(int cacheSizeLimit) {
        FilePreviewPanel.setCacheSizeLimit(cacheSizeLimit);
    }

    public static int getCacheSizeLimit() {
        return FilePreviewPanel.getCacheSizeLimit();
    }

    public void setNode(NodeAbstract node) {
        this.node = node;
        this.filePreviewPanelContainer.removeAll();
        if (this.node != null) {
            this.filePreviewPanelContainer.add((Component)FilePreviewPanel.create(node, this), "Center");
        }
        this.enableOrDisableButtons();
    }

    public boolean isPreviewInSeparateWindow() {
        return this.filePreviewFrame != null && this.filePreviewFrame.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFileExternallyButtonClicked(NodeAbstract node) {
        if (node == null) {
            return;
        }
        if (node.isFolder()) {
            return;
        }
        String tempFileName = FileUtil.getTempFolder() + "/" + node.getFile().getName();
        try {
            if (!new File(tempFileName).exists()) {
                FileUtil.copyToOverwriting((String)node.getAbsolutePathString(), (String)tempFileName);
                new File(tempFileName).setWritable(false);
            }
            SystemProcess.openExternally((String)tempFileName);
        }
        catch (SystemProcessCantLaunchApplicationException e) {
            JOptionPane.showMessageDialog(this, I18N.translate((String)"MessageCantOpenFileExternally"), I18N.translate((String)"TitleCantOpenFileExternally"), 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.toString(), I18N.translate((String)"TitleCantOpenFileExternally"), 0);
        }
        finally {
            new File(tempFileName).deleteOnExit();
        }
    }

    @Override
    public void repaint() {
        if (this.isPreviewInSeparateWindow()) {
            this.filePreviewFrame.validate();
            this.filePreviewFrame.repaint();
        } else {
            super.repaint();
        }
    }

    private void openFileSeparatelyButtonClicked(NodeAbstract node) {
        if (this.filePreviewFrame == null) {
            this.filePreviewFrame = new JFrame();
            this.filePreviewFrame.setDefaultCloseOperation(0);
            this.filePreviewFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    FilePreviewer.this.closeWindowButtonClicked();
                }
            });
            this.filePreviewFrame.setSize(new Dimension(800, 800));
            this.filePreviewFrame.setLocationRelativeTo(null);
        }
        if (this.filePreviewFrame.isVisible()) {
            this.filePreviewFrame.toFront();
            this.filePreviewFrame.requestFocus();
            return;
        }
        this.remove(this.filePreviewPanelContainer);
        this.validate();
        this.repaint();
        this.filePreviewFrame.add(this.filePreviewPanelContainer);
        this.filePreviewFrame.setVisible(true);
        this.filePreviewFrame.toFront();
        this.filePreviewFrame.requestFocus();
    }

    private void closeWindowButtonClicked() {
        this.filePreviewFrame.setVisible(false);
        this.filePreviewFrame.remove(this.filePreviewPanelContainer);
        this.add((Component)this.filePreviewPanelContainer, "Center");
        this.validate();
        this.repaint();
        this.enableOrDisableButtons();
    }

    private void enableOrDisableButtons() {
        if (this.node == null) {
            this.openFileExternallyButton.setEnabled(false);
            this.openFileSeparatelyButton.setEnabled(false);
            return;
        }
        if (this.node.isFolder()) {
            this.openFileExternallyButton.setEnabled(false);
        } else {
            this.openFileExternallyButton.setEnabled(true);
        }
        this.openFileSeparatelyButton.setEnabled(true);
    }
}

