/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView;

import ch.docuteam.packer.gui.sipView.tableModel.MetadataTableModel;
import ch.docuteam.tools.file.exception.FileIsNotADirectoryException;
import ch.docuteam.tools.gui.JTableWithSpecificCellEditorPerRow;
import ch.docuteam.tools.gui.TableModelWithSpecificCellEditorPerRow;
import ch.docuteam.tools.os.SystemProcess;
import ch.docuteam.tools.os.SystemProcessCantLaunchApplicationException;
import ch.docuteam.tools.os.SystemProcessException;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.translations.I18N;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;

public class MetadataTable
extends JTableWithSpecificCellEditorPerRow {
    private final int FontSizeMagicNumber = 5;
    private final Font Font = (Font)UIManager.get("Table.font");
    private final int FontSize = this.Font.getSize() + 5;

    public MetadataTable(MetadataTableModel tableModel, int ... toolTipTextColumnIndexes) {
        super((TableModelWithSpecificCellEditorPerRow)tableModel, toolTipTextColumnIndexes);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MetadataTable target;
                String cellValue;
                if (e.isControlDown() && (cellValue = (target = (MetadataTable)((Object)e.getSource())).getModel().getValueAt(target.rowAtPoint(e.getPoint()), target.columnAtPoint(e.getPoint())).toString()).matches("^(https?|ftp|file)://.*")) {
                    try {
                        SystemProcess.openExternally((String)cellValue);
                    }
                    catch (FileIsNotADirectoryException | SystemProcessCantLaunchApplicationException | SystemProcessException | IOException | InterruptedException | URISyntaxException ex) {
                        Logger.error((Object)"Could not open URL", (Throwable)ex);
                    }
                }
            }
        });
        this.getTableHeader().setReorderingAllowed(false);
    }

    public String getToolTipText(MouseEvent e) {
        switch (this.columnAtPoint(e.getPoint())) {
            case 0: {
                return I18N.translate((String)"ToolTipDynamicMetadataTypes");
            }
            case 1: {
                return ((MetadataTableModel)this.dataModel).getToolTipText(this.rowAtPoint(e.getPoint()));
            }
        }
        return super.getToolTipText(e);
    }

    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        MetadataTableModel model = (MetadataTableModel)e.getSource();
        for (int i = 0; i < model.getRowCount(); ++i) {
            int requiredRowHeight;
            int rows = model.get(i).getLevelMetadataElement().getDisplayRows();
            if (rows == 0) {
                rows = 1;
            }
            if ((requiredRowHeight = this.FontSize * rows) <= 0 || requiredRowHeight == this.getRowHeight(i)) continue;
            this.setRowHeight(i, requiredRowHeight);
        }
    }
}

