/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView;

import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.tools.translations.I18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class SearchPanel
extends JPanel {
    private SIPView sipView;
    protected JTextField searchTextField;
    protected JTextField hitCountTextField;
    protected Action searchAction;
    protected Action clearSearchTextFieldAction;
    protected Action selectNextHitAction;
    protected Action selectPreviousHitAction;
    protected List<NodeAbstract> hits = new Vector<NodeAbstract>();
    protected int currentHitSelectionIndex = -1;

    protected SearchPanel(SIPView sipView) {
        super(new BorderLayout());
        this.sipView = sipView;
        this.searchTextField = new JTextField();
        this.searchTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.searchButtonClicked();
            }
        });
        this.searchTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SearchPanel.this.enableOrDisableActions();
            }
        });
        this.searchTextField.setToolTipText(I18N.translate((String)"ToolTipSearchTextField"));
        this.searchTextField.getInputMap(0).put(KeyStroke.getKeyStroke(40, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "SearchNext");
        this.searchTextField.getActionMap().put("SearchNext", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.selectNextButtonClicked();
            }
        });
        this.searchTextField.getInputMap(0).put(KeyStroke.getKeyStroke(38, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "SearchPrevious");
        this.searchTextField.getActionMap().put("SearchPrevious", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.selectPreviousButtonClicked();
            }
        });
        this.searchAction = new AbstractAction(I18N.translate((String)"ActionSearch"), PackerConstants.getImageIcon("Search.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.searchButtonClicked();
            }
        };
        this.searchAction.putValue("ShortDescription", I18N.translate((String)"ToolTipSearch"));
        this.searchAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.clearSearchTextFieldAction = new AbstractAction(I18N.translate((String)"ActionSearchClearTextField"), PackerConstants.getImageIcon("Clear.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.clearSearchTextFieldButtonClicked();
            }
        };
        this.clearSearchTextFieldAction.putValue("ShortDescription", I18N.translate((String)"ToolTipSearchClearTextField"));
        this.clearSearchTextFieldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 512));
        this.selectNextHitAction = new AbstractAction(I18N.translate((String)"ActionSearchSelectNext"), PackerConstants.getImageIcon("SearchNext.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.selectNextButtonClicked();
            }
        };
        this.selectNextHitAction.putValue("ShortDescription", I18N.translate((String)"ToolTipSearchSelectNext"));
        this.selectNextHitAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 512));
        this.selectPreviousHitAction = new AbstractAction(I18N.translate((String)"ActionSearchSelectPrevious"), PackerConstants.getImageIcon("SearchPrevious.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.selectPreviousButtonClicked();
            }
        };
        this.selectPreviousHitAction.putValue("ShortDescription", I18N.translate((String)"ToolTipSearchSelectPrevious"));
        this.selectPreviousHitAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 512));
        this.hitCountTextField = new JTextField();
        this.hitCountTextField.setEnabled(false);
        this.hitCountTextField.setColumns(4);
        JButton searchButton = new JButton(this.searchAction);
        searchButton.setHideActionText(true);
        JButton clearSearchTextFieldButton = new JButton(this.clearSearchTextFieldAction);
        clearSearchTextFieldButton.setHideActionText(true);
        JButton selectNextHitButton = new JButton(this.selectNextHitAction);
        selectNextHitButton.setHideActionText(true);
        JButton selectPreviousHitButton = new JButton(this.selectPreviousHitAction);
        selectPreviousHitButton.setHideActionText(true);
        Box buttonBox = new Box(0);
        buttonBox.add(searchButton);
        buttonBox.add(clearSearchTextFieldButton);
        buttonBox.add(selectNextHitButton);
        buttonBox.add(selectPreviousHitButton);
        buttonBox.add(this.hitCountTextField);
        this.add((Component)this.searchTextField, "Center");
        this.add((Component)buttonBox, "East");
        this.enableOrDisableActions();
    }

    private void searchButtonClicked() {
        if (this.searchTextField.getText().trim().isEmpty()) {
            this.hits.clear();
            this.currentHitSelectionIndex = -1;
        } else {
            this.hits = this.sipView.getDocument().searchForAllQuoted(this.searchTextField.getText());
            if (this.hits.isEmpty()) {
                this.currentHitSelectionIndex = -1;
                this.sipView.setFooterText(I18N.translate((String)"MessageSearchNothingFound"), true);
            } else {
                this.currentHitSelectionIndex = 0;
                this.selectNode(this.hits.get(this.currentHitSelectionIndex));
                this.sipView.setFooterText(I18N.translate((String)"MessageSearchFound", (Object[])new Object[]{this.hits.size()}));
            }
        }
        this.enableOrDisableActions();
    }

    private void clearSearchTextFieldButtonClicked() {
        this.searchTextField.setText("");
        this.searchButtonClicked();
    }

    private void selectNextButtonClicked() {
        if (this.hits.isEmpty()) {
            return;
        }
        if (this.currentHitSelectionIndex < this.hits.size() - 1) {
            ++this.currentHitSelectionIndex;
        }
        this.selectNode(this.hits.get(this.currentHitSelectionIndex));
        this.enableOrDisableActions();
    }

    private void selectPreviousButtonClicked() {
        if (this.hits.isEmpty()) {
            return;
        }
        if (this.currentHitSelectionIndex > 0) {
            --this.currentHitSelectionIndex;
        }
        this.selectNode(this.hits.get(this.currentHitSelectionIndex));
        this.enableOrDisableActions();
    }

    private void selectNode(NodeAbstract node) {
        if (node == null) {
            return;
        }
        this.sipView.selectNode(node);
    }

    private void enableOrDisableActions() {
        if (this.searchTextField.getText().isEmpty()) {
            this.clearSearchTextFieldAction.setEnabled(false);
            this.searchAction.setEnabled(false);
        } else {
            this.clearSearchTextFieldAction.setEnabled(true);
            this.searchAction.setEnabled(true);
        }
        if (this.hits.isEmpty()) {
            this.selectNextHitAction.setEnabled(false);
            this.selectPreviousHitAction.setEnabled(false);
        } else {
            if (this.currentHitSelectionIndex > 0) {
                this.selectPreviousHitAction.setEnabled(true);
            } else {
                this.selectPreviousHitAction.setEnabled(false);
            }
            if (this.currentHitSelectionIndex < this.hits.size() - 1) {
                this.selectNextHitAction.setEnabled(true);
            } else {
                this.selectNextHitAction.setEnabled(false);
            }
        }
        this.updateHitCountTextField();
    }

    private void updateHitCountTextField() {
        this.hitCountTextField.setText(this.currentHitSelectionIndex + 1 + "/" + this.hits.size());
    }
}

