/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.exceptions.MetadataElementIsNotAllowedException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotDefinedException;
import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mdconfig.MetadataElementValidator;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.tools.translations.I18N;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MetadataElementValidatorDateHierarchyYear
implements MetadataElementValidator {
    @Override
    public void check(String value, NodeAbstract context, MetadataElement metadataElement) throws MetadataElementValidatorException {
        if (value == null || value.isEmpty()) {
            return;
        }
        if (value.equals(I18N.translate_NoCheck((String)"NoDate"))) {
            return;
        }
        if (!metadataElement.getAccessorName().startsWith("from") && !metadataElement.getAccessorName().startsWith("to")) {
            throw new MetadataElementValidatorException("cannot form a logic for this metadata element");
        }
        try {
            if (!context.isRoot().booleanValue()) {
                String parentGenericValue = ((NodeFolder)context.getParent()).getDynamicMetadataValueForName(metadataElement.getAccessorName());
                if (parentGenericValue == null || parentGenericValue.isEmpty()) {
                    return;
                }
                Date parentDateValue = new SimpleDateFormat("yyyy").parse(parentGenericValue);
                if (metadataElement.getAccessorName().startsWith("from")) {
                    if (parentDateValue.after(new SimpleDateFormat("yyyy").parse(value))) {
                        throw new MetadataElementValidatorException("the value is chronologically before the parent's value");
                    }
                } else if (metadataElement.getAccessorName().startsWith("to") && parentDateValue.before(new SimpleDateFormat("yyyy").parse(value))) {
                    throw new MetadataElementValidatorException("the value is chronologically after the parent's value");
                }
            }
            if (context.isFolder()) {
                for (NodeAbstract node : ((NodeFolder)context).getDescendants()) {
                    String childGenericValue = node.getDynamicMetadataValueForName(metadataElement.getAccessorName());
                    if (childGenericValue == null || childGenericValue.isEmpty()) continue;
                    Date childDateValue = new SimpleDateFormat("yyyy").parse(childGenericValue);
                    if (metadataElement.getAccessorName().startsWith("from")) {
                        if (!childDateValue.before(new SimpleDateFormat("yyyy").parse(value))) continue;
                        throw new MetadataElementValidatorException("the value is chronologically after the child's value");
                    }
                    if (!metadataElement.getAccessorName().startsWith("to") || !childDateValue.after(new SimpleDateFormat("yyyy").parse(value))) continue;
                    throw new MetadataElementValidatorException("the value is chronologically before the child's value");
                }
            }
        }
        catch (ParseException e) {
            throw new MetadataElementValidatorException("parse error: could not parse the value '" + value + "' as a year ('yyyy')");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new MetadataElementValidatorException("error accessing the parent's metadata");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new MetadataElementValidatorException("error accessing the parent's metadata");
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new MetadataElementValidatorException("error accessing the parent's metadata");
        }
        catch (MetadataElementIsNotAllowedException e) {
            e.printStackTrace();
            throw new MetadataElementValidatorException("error accessing the parent's metadata (element is not allowed)");
        }
        catch (MetadataElementIsNotDefinedException e) {
            e.printStackTrace();
            throw new MetadataElementValidatorException("error accessing the parent's metadata (element is not defined)");
        }
    }
}

