/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mdconfig.MetadataElementValidator;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.tools.translations.I18N;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class MetadataElementValidatorDateYYYYMMDD
implements MetadataElementValidator {
    private String dateRegex = "^\\d{4}(1[0-2]|0[0-9])([0-2]\\d{1}|3[0-1])$";
    private String dateNotKnownRegex = "^\\d{4}((1[0-2]|0[0-9])00)";
    private String dateFormat = "yyyyMMdd";

    @Override
    public void check(String value, NodeAbstract context, MetadataElement metadataElement) throws MetadataElementValidatorException {
        block4: {
            Date date = null;
            Pattern p = Pattern.compile(this.dateRegex);
            if (p.matcher(value).matches()) {
                try {
                    Pattern unfullDatePattern;
                    SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
                    date = sdf.parse(value);
                    if (!value.equals(sdf.format(date)) && !(unfullDatePattern = Pattern.compile(this.dateNotKnownRegex)).matcher(value).matches()) {
                        throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorDateYYYYMMDDCantConvert", (Object[])new Object[]{value}));
                    }
                    break block4;
                }
                catch (ParseException ex) {
                    throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorDateYYYYMMDDCantConvert", (Object[])new Object[]{value}));
                }
            }
            throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorDateYYYYMMDDCantConvert", (Object[])new Object[]{value}));
        }
    }
}

