/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mets.filesec;

import ch.docuteam.darc.common.DocumentAbstract;
import ch.docuteam.darc.common.NodeAbstract;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.filesec.FileSection;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.tools.file.MetadataProviderDROID;
import ch.docuteam.tools.id.UniqueID;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class File
extends NodeAbstract {
    protected static final String HrefPrefix = "file:///";
    protected static final String LocType = "URL";
    protected static final String Xmlns_xlink = "http://www.w3.org/1999/xlink";
    protected String mimeType;
    protected String locType = "URL";
    protected String href;

    protected File() {
    }

    public File(DocumentAbstract document, String newRelativeFilePath) {
        this.document = document;
        this.parent = ((Document)this.document).getFileSection();
        this.element = ((Element)this.parent.getElement().selectSingleNode("./METS:fileGrp")).addElement("METS:file");
        this.element.addElement("METS:FLocat").addAttribute("LOCTYPE", this.locType);
        this.setId(UniqueID.getXML());
        ((FileSection)this.parent).add(this);
        this.setHrefAddPrefix(newRelativeFilePath);
        try {
            this.setMimeType(MetadataProviderDROID.getMimeType((String)this.getAbsoluteFilePath()));
        }
        catch (Exception ex) {
            this.setMimeType("");
        }
        this.document.setIsModified();
    }

    private File(FileSection parent, Element fileElement) {
        this.document = parent.getDocument();
        this.parent = parent;
        this.element = fileElement;
        this.id = fileElement.attributeValue("ID");
        this.mimeType = fileElement.attributeValue("MIMETYPE");
        Element fileLocationSubNode = (Element)fileElement.selectSingleNode("./METS:FLocat");
        this.locType = fileLocationSubNode.attributeValue("LOCTYPE");
        this.href = fileLocationSubNode.attributeValue("href");
    }

    protected static List<File> parse(FileSection parent) {
        ArrayList<File> fileList = new ArrayList<File>();
        for (Object o : parent.getElement().selectNodes("./METS:fileGrp/METS:file")) {
            fileList.add(new File(parent, (Element)o));
        }
        return fileList;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getLocType() {
        return this.locType;
    }

    public String getHref() {
        return this.href;
    }

    public String getAbsoluteFilePath() {
        return ((Document)this.document).getSIPFolder() + "/" + this.href.substring(HrefPrefix.length());
    }

    public java.io.File getFile() {
        return new java.io.File(this.getAbsoluteFilePath());
    }

    public void delete() {
        ((FileSection)this.parent).delete(this);
        this.element.detach();
        this.document.setIsModified();
    }

    public void rename(String newName) {
        this.setHrefAddPrefix(newName);
    }

    public void moveTo(NodeFolder toFolder) {
        this.setHrefAddPrefix(toFolder.getPathString() + this.href.substring(this.href.lastIndexOf("/")));
    }

    public void replaceInFilePath(String old, String replace) {
        this.setHref(this.href.replaceFirst(Pattern.quote(HrefPrefix + old), HrefPrefix + replace));
    }

    public void replaceFile(String fileName) {
        this.setHref(this.href.substring(0, this.href.lastIndexOf("/") + 1) + fileName);
        try {
            this.setMimeType(MetadataProviderDROID.getMimeType((String)this.getAbsoluteFilePath()));
        }
        catch (Exception e) {
            ch.docuteam.tools.exception.Exception.remember((Throwable)e);
        }
    }

    public String toString() {
        return "[FileSectionFile:id=" + (this.id + "(") + (this.mimeType + ")href=") + (this.href + "]");
    }

    protected void setMimeType(String mimeType) {
        this.mimeType = mimeType;
        this.element.addAttribute("MIMETYPE", this.mimeType);
        this.document.setIsModified();
    }

    protected void setHref(String href) {
        this.href = href;
        ((Element)this.element.selectSingleNode("./METS:FLocat")).addAttribute(new QName("href", new Namespace("xlink", Xmlns_xlink)), this.href);
        this.document.setIsModified();
    }

    public void setHrefAddPrefix(String href) {
        this.setHref(HrefPrefix + href);
    }
}

