/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.converter;

import ch.docuteam.converter.dpf4.ConvertOperation;
import ch.docuteam.tools.out.Logger;
import com.sealsystems.dpf4convert.v1_3_.DPF4ConvertService;
import com.sealsystems.dpf4convert.v1_3_.Dpf4CService;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Optional;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

public class DPF4Converter {
    private static final String pdf4convertServiceURLKey = "pdf4convert.service.url";
    private static final String pdf4convert_MTOM_ThresholdKey = "pdf4convert.mtom.threshold";
    private static final String pdf4convert_CXF_TimeoutKey = "pdf4convert.cxf.timeout";
    private static final int MTOM_DEFAULT_THRESHOLD = 1000;
    private static final int CXF_DEFAULT_CLIENT_TIMEOUT = 60000;
    private static final String pdf4convertServiceDefaultAddress = "http://localhost:9125/dpf4c-service-v1.3/convert";
    private static final int INET_TIMEOUT = 5000;
    private static URL wsdlURL;
    private static String serviceURL;
    private static int mtomThreshold;
    private static int cxfTimeout;
    private static Dpf4CService service;

    public static void setServiceURL(String serviceURLNew) {
        Logger.info((Object)("Initialize serviceURL: " + serviceURLNew));
        serviceURL = serviceURLNew;
        String wsdlLocation = DPF4Converter.getWSDLLocation(serviceURL);
        try {
            wsdlURL = new URL(wsdlLocation);
        }
        catch (MalformedURLException e) {
            Logger.error((Object)("Could not generate WSDL location URL: " + wsdlLocation), (Throwable)e);
        }
        service = null;
    }

    public static void setMTOMThreshold(int mtomThresholdNew) {
        Logger.info((Object)("Initialize MTOM threshold: " + mtomThresholdNew));
        mtomThreshold = mtomThresholdNew;
        service = null;
    }

    public static void initialize() {
        if (service != null) {
            return;
        }
        if (!DPF4Converter.isDPF4ConverterReachable()) {
            Logger.error((Object)("DPF4Converter unreachable: " + serviceURL));
            return;
        }
        if (wsdlURL == null) {
            Logger.error((Object)("DPF4Converter WSDL not found: " + wsdlURL));
            return;
        }
        DPF4ConvertService dpf4ConvertService = new DPF4ConvertService(wsdlURL, DPF4ConvertService.SERVICE);
        Boolean mtomEnabled = true;
        service = dpf4ConvertService.getSOAP11(new WebServiceFeature[]{new MTOMFeature(mtomEnabled.booleanValue(), mtomThreshold)});
        Client cl = ClientProxy.getClient((Object)service);
        HTTPConduit httpConduit = (HTTPConduit)cl.getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout((long)cxfTimeout);
        httpClientPolicy.setReceiveTimeout((long)cxfTimeout);
        httpConduit.setClient(httpClientPolicy);
    }

    public static void main(String ... args) {
        DPF4Converter.initializeIfNecessary();
        Optional<ConvertOperation> op = ConvertOperation.createOperation(service, args);
        if (op.isPresent()) {
            op.get().run();
        } else {
            Logger.error((Object)"Invalid operation!");
            Logger.info((Object)("Usage: " + ConvertOperation.getSyntax()));
        }
    }

    private static String getWSDLLocation(String serviceURL) {
        return serviceURL + "?wsdl";
    }

    private static void initializeIfNecessary() {
        if (service == null) {
            DPF4Converter.initialize();
        }
    }

    private static boolean isDPF4ConverterReachable() {
        boolean isDPF4ConverterReachable = false;
        try {
            String otcsHost = new URI(serviceURL).getHost();
            isDPF4ConverterReachable = InetAddress.getByName(otcsHost).isReachable(5000);
        }
        catch (URISyntaxException e) {
            Logger.warn((Object)("Invalid URI: " + serviceURL), (Throwable)e);
        }
        catch (UnknownHostException e) {
            Logger.warn((Object)("IP address can not be determined: " + serviceURL));
        }
        catch (IOException e) {
            Logger.warn((Object)("Network error while accessing: " + serviceURL));
        }
        catch (IllegalArgumentException e) {
            Logger.warn((Object)"Argument INET_TIMEOUT should not be negative", (Throwable)e);
        }
        return isDPF4ConverterReachable;
    }

    static {
        serviceURL = pdf4convertServiceDefaultAddress;
        mtomThreshold = 1000;
        cxfTimeout = 60000;
        boolean isPdf4convertServiceURLKey = false;
        if (System.getProperties().containsKey(pdf4convertServiceURLKey)) {
            isPdf4convertServiceURLKey = true;
            DPF4Converter.setServiceURL(System.getProperty(pdf4convertServiceURLKey));
        } else {
            DPF4Converter.setServiceURL(pdf4convertServiceDefaultAddress);
        }
        Logger.info((Object)String.format("Using DPF4Convert webservice URL: '%s' (%s)", serviceURL, isPdf4convertServiceURLKey ? pdf4convertServiceURLKey : "default"));
        boolean isPdf4convert_MTOM_ThresholdKey = false;
        if (System.getProperties().containsKey(pdf4convert_MTOM_ThresholdKey)) {
            mtomThreshold = Integer.valueOf(System.getProperty(pdf4convert_MTOM_ThresholdKey));
            isPdf4convert_MTOM_ThresholdKey = true;
        }
        Logger.info((Object)String.format("Using DPF4Convert MTOM threshold: '%d' (%s)", mtomThreshold, isPdf4convert_MTOM_ThresholdKey ? pdf4convert_MTOM_ThresholdKey : "default"));
        boolean isPdf4convert_CXF_TimeoutKey = false;
        if (System.getProperties().containsKey(pdf4convert_CXF_TimeoutKey)) {
            cxfTimeout = Integer.valueOf(System.getProperty(pdf4convert_CXF_TimeoutKey));
            isPdf4convert_CXF_TimeoutKey = true;
        }
        Logger.info((Object)String.format("Using DPF4Convert CXF timeout: '%d' (%s)", cxfTimeout, isPdf4convert_CXF_TimeoutKey ? pdf4convert_CXF_TimeoutKey : "default"));
    }
}

