/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.converter;

import ch.docuteam.converter.exceptions.OOConverterShallNotBeUsedException;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.ResourceUtil;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.os.OperatingSystem;
import ch.docuteam.tools.out.Logger;
import com.artofsolving.jodconverter.DocumentConverter;
import com.artofsolving.jodconverter.DocumentFormatRegistry;
import com.artofsolving.jodconverter.XmlDocumentFormatRegistry;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;

public class OOConverter {
    private static String DefaultPathBase = "apps";
    private static String DefaultPathMac = DefaultPathBase + "/OpenOffice.org.app";
    private static String DefaultPathWindows = DefaultPathBase + "/OpenOffice.org 3";
    private static String DefaultPathLinux = DefaultPathBase + "/openoffice4";
    private static final String PathRelativeMac = "/Contents/MacOS/soffice.bin";
    private static final String PathRelativeWindows = "/program/soffice.exe";
    private static final String PathRelativeLinux = "/program/soffice";
    private static final String DefaultHost = "localhost";
    private static final int DefaultPort = 8100;
    private static final String DefaultJODDocumentFormatsFile = "/config/document-formats.xml";
    private static final int DefaultNumberOfInitializationRetries = 20;
    private static String Path = OperatingSystem.isWindows() ? DefaultPathWindows : (OperatingSystem.isMacOSX() ? DefaultPathMac : DefaultPathLinux);
    private static String Host = "localhost";
    private static int Port = 8100;
    private static String JODDocumentFormatsFile = "/config/document-formats.xml";
    private static boolean ShallNotBeUsed = false;
    private static boolean IsInitializing = false;
    private static int NumberOfInitializationRetries = 20;
    private static OpenOfficeConnection Connection;
    private static DocumentConverter Converter;
    private static Process OOProcess;

    public static void main(String ... args) throws IOException, FileUtilExceptionListException, OOConverterShallNotBeUsedException {
        if (args.length != 2) {
            System.err.println("ERROR: Wrong number of arguments.");
            System.err.println("");
            System.err.println("Usage: OOConverter [path/to/]sourceFile [path/to/]destinationFile");
            return;
        }
        OOConverter.convert2PDF(args[0], args[1]);
    }

    public static void setJODDocumentsFormatFile(String newJODDocumentFormatsFile) {
        JODDocumentFormatsFile = newJODDocumentFormatsFile;
    }

    public static void setNumberOfInitializationRetries(Integer newNumberOfInitializationRetries) {
        if (newNumberOfInitializationRetries == null) {
            return;
        }
        if (newNumberOfInitializationRetries <= 0) {
            return;
        }
        NumberOfInitializationRetries = newNumberOfInitializationRetries;
    }

    public static Integer getNumberOfInitializationRetries() {
        return NumberOfInitializationRetries;
    }

    public static String getConverterPath() {
        return Path;
    }

    public static void setConverterPath(String path) {
        try {
            if (OperatingSystem.isWindows()) {
                DefaultPathWindows = path;
                DefaultPathBase = new File(DefaultPathWindows).getParentFile().getCanonicalPath();
            } else if (OperatingSystem.isMacOSX()) {
                DefaultPathMac = path;
                DefaultPathBase = new File(DefaultPathMac).getParentFile().getCanonicalPath();
            } else {
                DefaultPathLinux = path;
                DefaultPathBase = new File(DefaultPathLinux).getParentFile().getCanonicalPath();
            }
            Path = path;
        }
        catch (IOException e) {
            Logger.error((Object)("setConverterPath failed: " + e));
        }
    }

    public static boolean shallNotBeUsed() {
        return ShallNotBeUsed;
    }

    public static void initializeDontWait(String ooConverterPath, String ooConverterHost, Integer ooConverterPort) {
        if (ooConverterHost != null && !ooConverterHost.isEmpty()) {
            Host = ooConverterHost;
        }
        if (ooConverterPort != null) {
            Port = ooConverterPort;
        }
        OOConverter.initializeDontWait(ooConverterPath);
    }

    public static void initializeDontWait(String ooConverterPath) {
        if (ooConverterPath != null && !ooConverterPath.isEmpty()) {
            Path = FileUtil.asCanonicalFileName((String)ooConverterPath);
        }
        OOConverter.initializeDontWait();
    }

    public static void initializeDontWait() {
        new SwingWorker<Integer, Object>(){

            @Override
            public Integer doInBackground() {
                OOConverter.initialize();
                return 0;
            }
        }.execute();
    }

    public static void initialize(String ooConverterPath, String ooConverterHost, Integer ooConverterPort) {
        if (ooConverterHost != null && !ooConverterHost.isEmpty()) {
            Host = ooConverterHost;
        }
        if (ooConverterPort != null) {
            Port = ooConverterPort;
        }
        OOConverter.initialize(ooConverterPath);
    }

    public static void initialize(String ooConverterPath) {
        if (ooConverterPath != null && !ooConverterPath.isEmpty()) {
            Path = FileUtil.asCanonicalFileName((String)ooConverterPath);
        }
        OOConverter.initialize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initialize() {
        if (Converter != null) {
            return;
        }
        while (IsInitializing) {
            Logger.getLogger().debug("Waiting for initialization to finish...");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (Converter != null) {
            return;
        }
        Converter = OOConverter.createConverter();
        if (Converter != null) {
            return;
        }
        String ooConverterCompletePath = Path;
        if (OperatingSystem.isWindows()) {
            ooConverterCompletePath = ooConverterCompletePath + PathRelativeWindows;
        } else if (OperatingSystem.isMacOSX()) {
            ooConverterCompletePath = ooConverterCompletePath + PathRelativeMac;
        } else if (OperatingSystem.isLinux()) {
            ooConverterCompletePath = ooConverterCompletePath + PathRelativeLinux;
        }
        Logger.getLogger().debug("Starting OO Service on host:'" + Host + "' port:'" + Port + "' path:'" + ooConverterCompletePath + "'");
        try {
            IsInitializing = true;
            try {
                if (!new File(ooConverterCompletePath).exists()) {
                    if (Path.startsWith(DefaultPathBase)) {
                        Logger.getLogger().info("Could not find the default OO application for converting files in folder: " + Path);
                        ShallNotBeUsed = true;
                        return;
                    }
                    System.out.println("I was told that the OO application is right there.");
                    System.out.println("Maybe this location is wrong or the OO application is not installed there?");
                    throw new FileNotFoundException(ooConverterCompletePath);
                }
                OOProcess = Runtime.getRuntime().exec(new String[]{ooConverterCompletePath, "-headless", "-nologo", "-norestore", "-nofirststartwizard", "-accept=socket,host=" + Host + ",port=" + Port + ";urp;StarOffice.Service"});
            }
            catch (IOException x) {
                x.printStackTrace();
                IsInitializing = false;
                return;
            }
            int i = NumberOfInitializationRetries;
            while (i > 0) {
                Logger.getLogger().debug(i + ":");
                Converter = OOConverter.createConverter();
                if (Converter != null) {
                    Logger.getLogger().debug("OOConverter established");
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --i;
            }
            return;
        }
        finally {
            IsInitializing = false;
        }
    }

    public static void disconnect() {
        if (Connection != null) {
            Logger.getLogger().debug("Disconnecting OOConverter...");
            try {
                Connection.disconnect();
                for (int i = NumberOfInitializationRetries; i > 0; --i) {
                    Logger.getLogger().debug(i + ":");
                    if (!Connection.isConnected()) {
                        Logger.getLogger().debug("Connection closed");
                        break;
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (NullPointerException i) {
            }
            finally {
                Connection = null;
            }
        }
        if (OOProcess != null) {
            Logger.getLogger().debug("Destroying OOProcess...");
            OOProcess.destroy();
            try {
                Logger.debug((Object)("Waiting up to " + OOConverter.getNumberOfInitializationRetries() + "s for process to terminate..."));
                OOProcess.waitFor(OOConverter.getNumberOfInitializationRetries().intValue(), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Logger.warn((Object)"Error destroying OO process", (Throwable)e);
            }
            if (OOProcess != null && OOProcess.isAlive()) {
                Logger.debug((Object)"Forcibly destroying OO process...");
                OOProcess.destroyForcibly();
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Path = OperatingSystem.isWindows() ? DefaultPathWindows : (OperatingSystem.isMacOSX() ? DefaultPathMac : DefaultPathLinux);
        Host = DefaultHost;
        Port = 8100;
        JODDocumentFormatsFile = DefaultJODDocumentFormatsFile;
        NumberOfInitializationRetries = 20;
        Converter = null;
        ShallNotBeUsed = false;
    }

    public static void convert2PDF(String sourceFileName, String destinationFileName) throws IOException, FileUtilExceptionListException, OOConverterShallNotBeUsedException {
        OOConverter.initializeIfNecessary();
        if (ShallNotBeUsed) {
            throw new OOConverterShallNotBeUsedException();
        }
        Logger.getLogger().info("Converting file: '" + sourceFileName + "' to PDF: '" + destinationFileName + "'");
        File sourceFile = new File(sourceFileName);
        File destinationFile = new File(destinationFileName);
        if (!sourceFile.exists()) {
            throw new FileNotFoundException(sourceFileName);
        }
        FileUtil.createFolderMerging((File)destinationFile.getParentFile());
        FileUtil.delete((File)destinationFile);
        try {
            Converter.convert(sourceFile, destinationFile);
        }
        catch (NullPointerException x) {
            Logger.getLogger().error("File conversion failed - maybe the OpenOffice service is not running?");
            throw x;
        }
    }

    public static boolean isInstalledLocallyForWindows() {
        return new File(DefaultPathWindows).exists();
    }

    public static boolean isInstalledLocallyForOSX() {
        return new File(DefaultPathMac).exists();
    }

    public static boolean isInstalledLocallyForLinux() {
        return new File(DefaultPathLinux).exists();
    }

    public static String getRemotePathForWindows() {
        return OperatingSystem.isWindows() ? Path : "";
    }

    public static String getRemotePathForOSX() {
        return OperatingSystem.isMacOSX() && !Path.equals(DefaultPathMac) ? Path : "";
    }

    public static String getRemotePathForLinux() {
        return OperatingSystem.isLinux() && !Path.equals(DefaultPathLinux) ? Path : "";
    }

    private static void initializeIfNecessary() {
        if (Converter == null) {
            OOConverter.initialize();
        }
    }

    private static DocumentConverter createConverter() {
        OpenOfficeDocumentConverter converter = null;
        try {
            Logger.getLogger().debug("Connecting to OO Service...");
            Connection = new SocketOpenOfficeConnection(Port);
            Connection.connect();
            try (InputStream inputStream = OOConverter.getJODDocumentFormatsFileInputStream();){
                Logger.getLogger().debug("Trying to initialize OO Service with initialization file '" + JODDocumentFormatsFile + "'");
                converter = new OpenOfficeDocumentConverter(Connection, (DocumentFormatRegistry)new XmlDocumentFormatRegistry(inputStream));
            }
            catch (IOException e1) {
                Logger.getLogger().debug("Initialization file '" + JODDocumentFormatsFile + "' not found, using defaults");
                converter = new OpenOfficeDocumentConverter(Connection);
            }
            Logger.getLogger().debug("... OO Service connected");
        }
        catch (ConnectException e) {
            Logger.getLogger().debug(e.toString());
        }
        return converter;
    }

    private static InputStream getJODDocumentFormatsFileInputStream() {
        return ResourceUtil.getResourceAsStream((String)JODDocumentFormatsFile);
    }
}

