/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.converter;

import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.out.Logger;
import ch.snb.pdfgenerator.SNBPDFGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public abstract class SNBPDFConverter {
    private static final String DefaultServiceURL = "http://pdfgeneratortest/SNBPDFGenerator.asmx";
    private static SNBPDFGenerator Generator;
    private static String ServiceURL;

    public static void main(String ... args) throws FileNotFoundException, MalformedURLException, IOException {
        if (args.length != 2 && args.length != 5) {
            System.err.println("ERROR: Wrong number of arguments.");
            System.err.println("");
            System.err.println("Usage: SNBPDFGenerator [path/to/]sourceFile [path/to/]destinationFile [pdfSettings securitySettings fileTypeSettings]");
            return;
        }
        if (args.length == 2) {
            SNBPDFConverter.convert2PDF(args[0], args[1]);
        } else if (args.length == 5) {
            SNBPDFConverter.convert2PDF(args[0], args[1], args[2], args[3], args[4]);
        }
    }

    public static void initialize() throws MalformedURLException {
        SNBPDFConverter.initialize(ServiceURL);
    }

    public static void initialize(String url) throws MalformedURLException {
        Logger.debug((Object)("Initializing service at: '" + url + "'"));
        Generator = new SNBPDFGenerator(new URL(url));
    }

    public static void convert2PDF(String sourceFilePath, String destinationFilePath) throws FileNotFoundException, MalformedURLException, IOException {
        SNBPDFConverter.convert2PDF(sourceFilePath, destinationFilePath, "", "", "");
    }

    public static void convert2PDF(String sourceFilePath, String destinationFilePath, String pdfSettings, String securitySettings, String fileTypeSettings) throws FileNotFoundException, MalformedURLException, IOException {
        SNBPDFConverter.initializeIfNecessary();
        if (Generator == null) {
            Logger.error((Object)"PDF generator can not be initialized");
            return;
        }
        Logger.info((Object)("Converting: '" + sourceFilePath + "' to: '" + destinationFilePath + "'"));
        FileInputStream fisSource = new FileInputStream(sourceFilePath);
        Logger.debug((Object)("Parameters:\tFileType = " + FileUtil.asFileNameExtension((String)sourceFilePath) + ", pdfSettings = " + pdfSettings + ", securitySettings = " + securitySettings + ", fileTypeSettings = " + fileTypeSettings));
        byte[] output = Generator.getSNBPDFGeneratorSoap().createPdfUsingCustomSettings(IOUtils.toByteArray((InputStream)fisSource), FileUtil.asFileNameExtension((String)sourceFilePath), pdfSettings, securitySettings, fileTypeSettings);
        Logger.debug((Object)("Output length: " + output.length));
        fisSource.close();
        FileUtils.writeByteArrayToFile((File)new File(destinationFilePath), (byte[])output);
    }

    private static void initializeIfNecessary() throws MalformedURLException {
        if (Generator == null) {
            SNBPDFConverter.initialize();
        }
    }

    static {
        ServiceURL = DefaultServiceURL;
    }
}

