/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import org.hibernate.annotations.Index;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationMethod;
import uk.gov.nationalarchives.droid.core.interfaces.NodeStatus;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceType;

@Embeddable
public class NodeMetaData {
    private static final int MAX_HASH_LENGTH = 64;
    @Index(name="idx_prn_file_size")
    @Column(name="file_size")
    private Long size;
    @Index(name="idx_prn_last_modified")
    @Column(name="last_modified_date")
    private Date lastModifiedDate;
    @Index(name="idx_prn_name")
    @Column(name="name", nullable=false)
    private String name;
    @Index(name="idx_prn_extension")
    @Column(name="extension")
    private String extension;
    @Index(name="idx_prn_node_status")
    @Column(name="node_status")
    @Enumerated(value=EnumType.ORDINAL)
    private NodeStatus nodeStatus;
    @Index(name="idx_prn_id_method")
    @Column(name="identification_method")
    @Enumerated(value=EnumType.ORDINAL)
    private IdentificationMethod identificationMethod;
    @Index(name="idx_prn_id_resourceType")
    @Column(name="resource_type", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private ResourceType resourceType;
    @Index(name="idx_prn_hash")
    @Column(name="hash", length=64)
    private String hash;

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModified(Long lastModified) {
        if (lastModified != null) {
            this.lastModifiedDate = new Date(lastModified);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension.toLowerCase();
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public NodeStatus getNodeStatus() {
        return this.nodeStatus;
    }

    public void setNodeStatus(NodeStatus nodeStatus) {
        this.nodeStatus = nodeStatus;
    }

    public IdentificationMethod getIdentificationMethod() {
        return this.identificationMethod;
    }

    public void setIdentificationMethod(IdentificationMethod identificationMethod) {
        this.identificationMethod = identificationMethod;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getHash() {
        return this.hash;
    }
}

