/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import de.schlichtherle.util.zip.BasicZipFile;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.results.handlers.ProgressObserver;

public class ProfileDiskAction {
    private static final int UNITY_PERCENT = 100;
    private static final int BUFFER_SIZE = 8192;
    private static final char FORWARD_SLASH = '/';
    private static final char BACKWARD_SLASH = '\\';
    private final Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProfile(String baseDir, File destination, ProgressObserver callback) throws IOException {
        this.log.info((Object)String.format("Saving profile [%s] to [%s]", baseDir, destination));
        File output = new File(destination.getAbsolutePath() + ".tmp~");
        if (!output.delete() && output.exists()) {
            String message = String.format("Could not delete original profile file: %s. Will try to delete on exit.", output.getAbsolutePath());
            this.log.warn((Object)message);
            output.deleteOnExit();
        }
        if (!output.createNewFile()) {
            throw new IOException(String.format("Error creating tmp file [%s]", output));
        }
        ProfileWalker profileWalker = new ProfileWalker(new File(baseDir), output, callback);
        try {
            profileWalker.save();
            callback.onProgress(100);
            if (destination.exists() && !destination.delete()) {
                throw new IOException(String.format("Error removing old file [%s]", destination));
            }
            if (!output.renameTo(destination)) {
                throw new IOException(String.format("Error creating saved file [%s]", destination));
            }
        }
        finally {
            profileWalker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File source, File destination, ProgressObserver observer) throws IOException {
        if (destination.exists()) {
            FileUtils.deleteDirectory((File)destination);
        }
        BasicZipFile zip = new BasicZipFile(source);
        try {
            long totalSize = 0L;
            Enumeration it = zip.entries();
            while (it.hasMoreElements()) {
                ZipEntry e = (ZipEntry)it.nextElement();
                totalSize += e.getSize();
            }
            long bytesSoFar = 0L;
            Enumeration it2 = zip.entries();
            while (it2.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)it2.nextElement();
                String entryName = this.getPlatformSpecificPath(entry.getName());
                File expandedFile = new File(destination + File.separator + entryName);
                BufferedInputStream in = new BufferedInputStream(zip.getInputStream(entry));
                FileUtils.forceMkdir((File)expandedFile.getParentFile());
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(expandedFile));
                bytesSoFar = this.readFile(in, out, observer, bytesSoFar, totalSize);
            }
            observer.onProgress(100);
        }
        finally {
            zip.close();
        }
    }

    private String getPlatformSpecificPath(String path) {
        String platformPath = null;
        switch (File.separatorChar) {
            case '\\': {
                platformPath = path.replace('/', '\\');
                break;
            }
            case '/': {
                platformPath = path.replace('\\', '/');
                break;
            }
            default: {
                platformPath = path.replaceAll("[\\\\/]", File.separator);
            }
        }
        return platformPath;
    }

    private String getUnixStylePath(String path) {
        return path.replace('\\', '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readFile(BufferedInputStream in, BufferedOutputStream out, ProgressObserver observer, long bytesSoFar, long totalSize) throws IOException {
        long totalBytesRead = bytesSoFar;
        try {
            int bytesIn = 0;
            byte[] buffer = new byte[8192];
            while ((bytesIn = in.read(buffer)) != -1) {
                int progressSoFar = (int)(100L * (totalBytesRead += (long)bytesIn) / totalSize);
                observer.onProgress(progressSoFar);
                out.write(buffer, 0, bytesIn);
            }
        }
        finally {
            try {
                in.close();
            }
            finally {
                out.close();
            }
        }
        return totalBytesRead;
    }

    private long writeFile(BufferedInputStream in, ZipOutputStream out, ProgressObserver observer, long bytesSoFar, long totalSize) throws IOException {
        long totalBytesWritten = bytesSoFar;
        int bytesIn = 0;
        byte[] buffer = new byte[8192];
        while ((bytesIn = in.read(buffer)) != -1) {
            int progressSoFar = (int)(100L * (totalBytesWritten += (long)bytesIn) / totalSize);
            observer.onProgress(progressSoFar);
            out.write(buffer, 0, bytesIn);
        }
        return totalBytesWritten;
    }

    private final class ProfileWalker
    extends DirectoryWalker {
        private String sourcePath;
        private File destination;
        private ZipOutputStream out;
        private File source;
        private ProgressObserver callback;
        private final long bytesToProcess;
        private long bytesProcessed;

        public ProfileWalker(File source, File destination, ProgressObserver callback) {
            this.sourcePath = source.getAbsolutePath() + File.separator;
            this.source = source;
            this.destination = destination;
            this.callback = callback;
            this.bytesToProcess = FileUtils.sizeOfDirectory((File)source);
        }

        public void close() throws IOException {
            this.out.close();
        }

        protected void handleStart(File startDirectory, Collection results) throws IOException {
            this.out = new ZipOutputStream((OutputStream)new FileOutputStream(this.destination));
            this.out.setMethod(8);
        }

        protected void handleEnd(Collection results) throws IOException {
            this.out.close();
        }

        protected boolean handleDirectory(File directory, int depth, Collection results) {
            return true;
        }

        protected void handleDirectoryStart(File directory, int depth, Collection results) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleFile(File file, int depth, Collection results) throws IOException {
            String entryPath = ProfileDiskAction.this.getUnixStylePath(StringUtils.substringAfter((String)file.getAbsolutePath(), (String)this.sourcePath));
            ZipEntry entry = new ZipEntry(entryPath);
            this.out.putNextEntry(entry);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                this.bytesProcessed = ProfileDiskAction.this.writeFile(in, this.out, this.callback, this.bytesProcessed, this.bytesToProcess);
            }
            finally {
                this.out.closeEntry();
                in.close();
            }
        }

        protected void save() throws IOException {
            this.walk(this.source, Collections.EMPTY_LIST);
        }
    }
}

